{ ABBREVW.PAS : Abbrevation list maintenance utility - Windows version

  Title   : ABBREVW
  Language: Borland Pascal 7.0 with Object Windows
  Version : 2.3
  Date    : Feb 06, 2000
  Author  : J R Ferguson
  Download: http://hello.to/ferguson
  E-mail  : j.r.ferguson@iname.com
  Usage   : MS-Windows 3.1 application

This program and its source may be used and copied freely without charge,
but only for non-commercial purposes. The author is not responsible for
any damage or loss of data that may be caused by using it.

To compile this source file, you wil need some units from the JRFPAS
Pascal routine library by the same author, which can be downloaded from the
Internet address mentioned above.

}

{ --- Compiler options --- }

{$B-} { Short-circuit Boolean expression evaluation }
{$V-} { Relaxed var-string checking }
{$X+} { Extended syntax }

{$DEFINE  DEBUG}
{$DEFINE  AUTOSAVE}

PROGRAM ABBREVW;

Uses BWCC, WinTypes, WinProcs, Objects, OWindows, ODialogs, OStdDlgs, Validate,
     WinDos, Strings, DefLib, BpwLib, StpLib, StfLib, StzLib;

{$R ABBREVW.RES}    { Resource file }
{$I ABBREVW.INC}    { Resource file related constants }
{$I OBJTYPE.INC}    { Object type Stream registration identification numbers }

const
  C_PrgTitle        = 'Abbrevations';
  C_PrgVersion      = 'v2.3';
  C_CopyRight       = '(c)1996-2000, J.R. Ferguson';
  C_AuthEmail       = 'j.r.ferguson@iname.com';
  C_AuthURL         = 'http://hello.to/ferguson';
  C_MainWindowClass = 'ABBWMAIN';
  C_FileWindowClass = 'ABBWFILE';
  C_Env_Setting     = 'SETTING'; { environment var for setting dir }
  C_SettingExt      = '.SET';
  C_DflOpenMask     = '*.ABB';
  C_KeyPos          = 2;
  C_KeyLen          = 7;
  C_DataPos         = 10;
  C_DataLen         = 69;
  cm0               = cm_First;
  wm0               = wm_First;
  wm_AdjustCmds     = wm_User+0;

type
  P_PathStr     = ^T_PathStr;
  P_PathStp     = ^T_PathStp;
  P_DirStr      = ^T_DirStr;
  P_NameStr     = ^T_NameStr;
  P_ExtStr      = ^T_ExtStr;
  P_MsgStr      = ^T_MsgStr;
  P_InpValidator= ^T_InpValidator;
  P_AbbInfoRec  = ^T_AbbInfoRec;
  P_EditAddDlg  = ^T_EditAddDlg;
  P_EditChgDlg  = ^T_EditChgDlg;
  P_EditDelDlg  = ^T_EditDelDlg;
  P_FindKeyBuf  = ^T_FindKeyBuf;
  P_FindKeyDlg  = ^T_FindKeyDlg;
  P_FindDataBuf = ^T_FindDataBuf;
  P_FindDataDlg = ^T_FindDataDlg;
  P_MergeFileDlg= ^T_MergeFileDlg;
  P_AbbList     = ^T_AbbList;
  P_FileWindow  = ^T_FileWindow;
  P_MainWindow  = ^T_MainWindow;
  P_Application = ^T_Application;

  T_PathStr  = array[0..fsPathName]   of char; T_PathStp = String[fsPathName];
  T_DirStr   = array[0..fsDirectory]  of char; T_DirStp  = String[fsDirectory];
  T_NameStr  = array[0..fsFileName]   of char;
  T_ExtStr   = array[0..fsExtension]  of char;
  T_KeyStr   = array[0..C_KeyLen]     of char; T_KeyStp  = String[C_KeyLen];
  T_DataStr  = array[0..C_DataLen]    of char; T_DataStp = String[C_DataLen];
  T_TitleStr = array[0..fsPathName+2] of char;
  T_MsgStr   = array[0..255]          of char;

  T_LastFind = (lf_None,lf_Key,lf_Data);

  T_InpValidator= Object(TFilterValidator)
    Constructor Init;
    function    IsValidInput(var V_String: String; V_NoFill: boolean):
                  boolean; virtual;
    function    IsValid(const V_String: String): boolean; virtual;
  end;

  T_AbbInfoRec  = record
    IO_Key      : T_KeyStr;
    IO_Data     : T_DataStr;
  end;

  T_EditAddDlg  = Object(TDialog)
    Constructor Init(V_Parent: PWindowsObject; V_IOBuf: P_AbbInfoRec);
  end;

  T_EditChgDlg  = Object(TDialog)
    Constructor Init(V_Parent: PWindowsObject; V_IOBuf: P_AbbInfoRec);
  end;

  T_EditDelDlg  = Object(TDialog)
    Constructor Init(V_Parent: PWindowsObject; V_IOBuf: P_AbbInfoRec);
  end;

  T_FindKeyBuf  = record
    IO_Key      : T_KeyStr;
  end;

  T_FindKeyDlg  = Object(TDialog)
    Constructor Init(V_Parent: PWindowsObject; V_IOBuf: P_FindKeyBuf);
  end;

  T_FindDataBuf = record
    IO_Data     : T_DataStr;
  end;

  T_FindDataDlg  = Object(TDialog)
    Constructor Init(V_Parent: PWindowsObject; V_IOBuf: P_FindDataBuf);
  end;

  T_MergeFileDlg= Object(TFileDialog)
    Constructor Init(V_Parent: PWindowsObject; V_FilePath: PChar);
  end;

  T_AbbList     = Object(TStringCollection)
    Constructor Init;
    function    InsertNew(V_Item: Pointer): boolean; virtual;
  end;

  T_FileWindow  = Object(T_ListWindow)
    FileName    : T_PathStp;
    LastFind    : T_LastFind;
    FindKey     : T_KeyStp;
    FindData    : T_DataStp;
    Changed     : boolean;
    Constructor Init(V_Parent: PWindowsObject);
    Destructor  Done; virtual;
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var V_Class: TWndClass); virtual;
    Constructor Load (var V_Stream: TStream);
    procedure   Store(var V_Stream: TStream);
    procedure   FileInit;
    procedure   FileTerm;
    procedure   SetChanged(V_Changed: boolean);
    function    IsChanged: boolean;
    procedure   ProcessItem (V_Row: integer); virtual;
    function    ReadList(V_Name: T_PathStp): P_AbbList;
    procedure   MergeList(V_Name: T_PathStp; V_List: P_AbbList);
    procedure   WriteList(V_Name: T_PathStp; V_List: P_AbbList);
    function    CanClose: boolean; virtual;
    procedure   CMFileNew   (var V_Msg:TMessage);virtual cm0+cm_FileNew   ;
    procedure   CMFileOpen  (var V_Msg:TMessage);virtual cm0+cm_FileOpen  ;
    procedure   CMFileMerge (var V_Msg:TMessage);virtual cm0+cm_FileMerge ;
    procedure   CMFileSave  (var V_Msg:TMessage);virtual cm0+cm_FileSave  ;
    procedure   CMFileSaveAs(var V_Msg:TMessage);virtual cm0+cm_FileSaveAs;
    procedure   CMEditAdd   (var V_Msg:TMessage);virtual cm0+cm_EditAdd   ;
    procedure   CMEditChange(var V_Msg:TMessage);virtual cm0+cm_EditChange;
    procedure   CMEditDelete(var V_Msg:TMessage);virtual cm0+cm_EditDelete;
    procedure   CMFindKey   (var V_Msg:TMessage);virtual cm0+cm_FindKey   ;
    procedure   CMFindDescr (var V_Msg:TMessage);virtual cm0+cm_FindDescr ;
    procedure   CMFindAgain (var V_Msg:TMessage);virtual cm0+cm_FindAgain ;
    procedure   CMFindDupl  (var V_Msg:TMessage);virtual cm0+cm_FindDupl  ;
    procedure   CMBottom    (var V_Msg:TMessage);virtual cm0+cm_Bottom    ;
    procedure   CMTop       (var V_Msg:TMessage);virtual cm0+cm_Top       ;
    procedure   WMAdjustCmds(var V_Msg:TMessage);virtual wm0+wm_AdjustCmds;
    procedure   DoAdjustCmds ;
    procedure   DoFileNew    ;
    procedure   DoFileOpen   ;
    procedure   DoFileMerge  ;
    procedure   DoFileSave   ;
    procedure   DoFileSaveAs ;
    procedure   DoEditAdd    ;
    procedure   DoEditChange ;
    procedure   DoEditDelete ;
    procedure   DoFindKey    ;
    procedure   DoFindData   ;
    procedure   DoFindKeyAgain ;
    procedure   DoFindDataAgain;
    procedure   DoFindAgain  ;
    procedure   DoFindDupl   ;
  end;

  T_MainWindow  = Object(TMDIWindow)
    ChildCount  : integer;
    Constructor Init(V_Title: PChar; V_Menu: HMenu);
    Destructor  Done; virtual;
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var V_Class: TWndClass); virtual;
    function    InitChild: PWindowsObject; virtual;
    procedure   SetupWindow; virtual;
    function    LoadDeskTop: boolean;
    procedure   SaveDeskTop;
    procedure   AdjustCommands;
    procedure   CMFileNew    (var V_Msg:TMessage);virtual cm0+cm_FileNew;
    procedure   CMFileOpen   (var V_Msg:TMessage);virtual cm0+cm_FileOpen;
    procedure   CMFileSaveAll(var V_Msg:TMessage);virtual cm0+cm_FileSaveAll;
    procedure   CMWinNew     (var V_Msg:TMessage);virtual cm0+cm_WinNew;
    procedure   CMHelpAbout  (var V_Msg:TMessage);virtual cm0+cm_HelpAbout;
    procedure   CMHelpInfo   (var V_Msg:TMessage);virtual cm0+cm_HelpInfo;
    procedure   DoFileNew    ;
    procedure   DoFileOpen   ;
    procedure   DoFileSaveAll;
    procedure   DoWinNew     ;
    procedure   DoHelpAbout  ;
    procedure   DoHelpInfo   ;
  end;

  T_Application = Object(TApplication)
    procedure   InitMainWindow; virtual;
    procedure   InitInstance; virtual;
    function    IdleAction: boolean; virtual;
  end;


const
  R_FileWindow  : TStreamRec = (
    ObjType : OT_ABBREVW_FileWindow;
    VmtLink : Ofs(TypeOf(T_FileWindow)^);
    Load    : @T_FileWindow.Load;
    Store   : @T_FileWindow.Store
  );

var
  PrgName    : T_NameStr;
  PrgDir     : T_DirStr;
  PrgIdent   : T_MsgStr;
  SettingTag : T_MsgStr;
  SettingPath: T_PathStr;


{ --- General --- }

procedure StreamRegistration;
begin
  RegisterObjects;
  RegisterODialogs;
  RegisterOWindows;
  RegisterBpwLib;
  RegisterType(R_FileWindow);
end;

procedure GetDirs;
var PrgPath: T_PathStr; PrgExt: T_ExtStr; SettingDir : T_PathStr;
    SRec: TSearchRec; n: StzInd; SettingVar: PChar;
begin
  FileExpand(PrgPath,StzStpCpy(PrgPath,ParamStr(0)));
  FileSplit(PrgPath,PrgDir,PrgName,PrgExt);
{$IFDEF DEBUG}
  StzCpy(SettingDir,PrgDir);
{$ELSE}
  SettingVar:= GetEnvVar(C_Env_Setting);
  if SettingVar = nil then StzCpy(SettingDir,PrgDir)
  else begin
    FileExpand(SettingDir,SettingVar);
    n:= StzLen(SettingDir)-1;
    if StzcRet(SettingDir,n) = '\' then StzDel(SettingDir,n,1);
    FindFirst(SettingDir,faDirectory,SRec);
    if DosError = 0 then StzcCat(SettingDir,'\')
                    else StzCpy(SettingDir,PrgDir);
  end;
{$ENDIF}
  StzCat(StzcECat(StzECpy(PrgIdent,PrgName),' '),C_PrgVersion);
  StzCat(StzECat(StzECpy(SettingPath,SettingDir),PrgName),C_SettingExt);
  StzCat(StzECpy(SettingTag,PrgIdent),' settings'#26);
end;

function AbbToString(V_AbbInfo: T_AbbInfoRec): String;
begin with V_AbbInfo do
  AbbToString:=
    ' '+StfFill(StrPas(IO_Key),' ',C_KeyLen)+' '+StfRTS(StrPas(IO_Data));
end;

procedure StringToAbb(V_String: String; var V_AbbInfo: T_AbbInfoRec);
begin with V_AbbInfo do begin
  StrPCopy(IO_Key ,StfRTS(StfSub(V_String,C_KeyPos ,C_KeyLen )));
  StrPCopy(IO_Data,StfRTS(StfSub(V_String,C_DataPos,C_DataLen)));
end; end;

procedure AdjustCommand(V_Command: word; V_Enabled: boolean);
begin
  if V_Enabled
  then EnableMenuItem(P_MainWindow(Application^.MainWindow)^.Attr.Menu, V_Command,
    mf_ByCommand or mf_Enabled)
  else EnableMenuItem(P_MainWindow(Application^.MainWindow)^.Attr.Menu, V_Command,
    mf_ByCommand or mf_Grayed);
end;

procedure AdjustFileCommands(V_Enabled: boolean);
begin
  AdjustCommand(cm_ArrangeIcons    ,V_Enabled);
  AdjustCommand(cm_TileChildren    ,V_Enabled);
  AdjustCommand(cm_CascadeChildren ,V_Enabled);
  AdjustCommand(cm_CloseChildren   ,V_Enabled);
  AdjustCommand(cm_FileSave        ,V_Enabled);
  AdjustCommand(cm_FileSave        ,V_Enabled);
  AdjustCommand(cm_FileSaveAs      ,V_Enabled);
  AdjustCommand(cm_FileSaveAll     ,V_Enabled);
  AdjustCommand(cm_FileMerge       ,V_Enabled);
  AdjustCommand(cm_EditAdd         ,V_Enabled);
end;

procedure AdjustEditCommands(V_Enabled: boolean);
begin
  AdjustCommand(cm_EditChange      ,V_Enabled);
  AdjustCommand(cm_EditDelete      ,V_Enabled);
  AdjustCommand(cm_FindKey         ,V_Enabled);
  AdjustCommand(cm_FindDescr       ,V_Enabled);
  AdjustCommand(cm_FindAgain       ,V_Enabled);
  AdjustCommand(cm_FindDupl        ,V_Enabled);
end;


{ --- T_InpValidator --- }

Constructor T_InpValidator.Init;
begin Inherited Init([' '..'~']); end;

function T_InpValidator.IsValidInput(var V_String: String; V_NoFill: boolean):
           boolean;
var i,n: byte;
begin
  if (Length(V_String) > 0) and (V_String[1] = ' ') then IsValidInput:= false
  else IsValidInput:= Inherited IsValidInput(V_String,V_NoFill);
end;

function T_InpValidator.IsValid(const V_String: String): boolean;
begin IsValid:= Inherited IsValid(V_String) and (Length(V_String) > 0); end;


{ --- T_EditAddDlg --- }

Constructor T_EditAddDlg.Init(V_Parent: PWindowsObject; V_IOBuf: P_AbbInfoRec);
var p: PEdit;
begin
  Inherited Init(V_Parent,MakeIntResource(Dlg_EditAdd));
  p:= New(PEdit,InitResource(@Self,id_AddKey,C_KeyLen+1));
    p^.SetValidator(New(P_InpValidator,Init));
  p:= New(PEdit,InitResource(@Self,id_AddData,C_DataLen+1));
    p^.SetValidator(New(P_InpValidator,Init));
  TransferBuffer:= V_IOBuf;
end;


{ --- T_EditChgDlg --- }

Constructor T_EditChgDlg.Init(V_Parent: PWindowsObject; V_IOBuf: P_AbbInfoRec);
var p: PEdit;
begin
  Inherited Init(V_Parent,MakeIntResource(Dlg_EditChange));
  p:= New(PEdit,InitResource(@Self,id_ChgKey,C_KeyLen+1));
    p^.SetValidator(New(P_InpValidator,Init));
  p:= New(PEdit,InitResource(@Self,id_ChgData,C_DataLen+1));
    p^.SetValidator(New(P_InpValidator,Init));
  TransferBuffer:= V_IOBuf;
end;


{ --- T_EditDelDlg --- }

Constructor T_EditDelDlg.Init(V_Parent: PWindowsObject; V_IOBuf: P_AbbInfoRec);
var p: PEdit;
begin
  Inherited Init(V_Parent,MakeIntResource(Dlg_EditDelete));
  p:= New(PEdit,InitResource(@Self,id_DelKey,C_KeyLen+1));
  p:= New(PEdit,InitResource(@Self,id_DelData,C_DataLen+1));
  TransferBuffer:= V_IOBuf;
end;


{ --- T_FindKeyDlg --- }

Constructor T_FindKeyDlg.Init(V_Parent: PWindowsObject; V_IOBuf: P_FindKeyBuf);
var p: PEdit;
begin
  Inherited Init(V_Parent,MakeIntResource(Dlg_FindKey));
  p:= New(PEdit,InitResource(@Self,id_Key,C_KeyLen+1));
  TransferBuffer:= V_IOBuf;
end;


{ --- T_FindDataDlg --- }

Constructor T_FindDataDlg.Init(V_Parent: PWindowsObject; V_IOBuf: P_FindDataBuf);
var p: PEdit;
begin
  Inherited Init(V_Parent,MakeIntResource(Dlg_FindDescr));
  p:= New(PEdit,InitResource(@Self,id_Descr,C_DataLen+1));
  TransferBuffer:= V_IOBuf;
end;


{ --- T_MergeFileDlg --- }

Constructor T_MergeFileDlg.Init(V_Parent: PWindowsObject; V_FilePath: PChar);
begin
  Inherited Init(V_Parent,MakeIntResource(sd_FileOpen),V_FilePath);
  StrDispose(Caption); Caption:= StrNew('File Merge');
end;


{ --- T_AbbList --- }

Constructor T_AbbList.Init;   begin Inherited Init(100,50); end;

function    T_AbbList.InsertNew(V_Item: Pointer): boolean;
var i: integer;
begin
  if not Search(KeyOf(V_Item),i) or Duplicates then begin
    AtInsert(i,V_Item);
    InsertNew:= true;
  end
  else InsertNew:= false;
end;


{ --- T_FileWindow --- }

Constructor T_FileWindow.Init(V_Parent: PWindowsObject);
begin
  Inherited Init(V_Parent,'',New(P_AbbList,Init));
  ScrnFont^.LogFont.lfHeight:= 15;
  FileName:= ''; Inc(P_MainWindow(Application^.MainWindow)^.ChildCount); FileInit;
end;

Destructor  T_FileWindow.Done;
begin
  FileTerm;
  Dec(P_MainWindow(Application^.MainWindow)^.ChildCount);
  Inherited Done;
end;

function    T_FileWindow.GetClassName: PChar;
begin GetClassName:= C_FileWindowClass; end;

procedure   T_FileWindow.GetWindowClass(var V_Class: TWndClass);
begin
  Inherited GetWindowClass(V_Class);
  V_Class.hIcon:= LoadIcon(HInstance,MakeIntResource(Ico_File));
end;

Constructor T_FileWindow.Load (var V_Stream: TStream);
begin
  Inherited Load(V_Stream);
  V_Stream.Read(FileName,SizeOf(FileName));
  if FileName = '' then NewList(New(P_AbbList,Init))
		   else NewList(ReadList(FileName));
  Inc(P_MainWindow(Application^.MainWindow)^.ChildCount);
  FileInit;
end;

procedure   T_FileWindow.Store(var V_Stream: TStream);
begin
  NewList(nil);
  Inherited Store(V_Stream);
  V_Stream.Write(FileName,SizeOf(FileName));
end;

procedure   T_FileWindow.FileInit;
var Title: T_TitleStr;
begin
  FindKey:= ''; FindData:= ''; LastFind:= lf_None; Changed:= false;
  SetCaption(StrPCopy(Title,FileName));
  InvalidateRect(HWindow,nil,true);
end;

procedure   T_FileWindow.FileTerm;
begin FileName:= ''; NewList(New(P_AbbList,Init)); FileInit; end;

procedure   T_FileWindow.SetChanged(V_Changed: boolean);
var Title: T_TitleStr;
begin if V_Changed <> Changed then begin
  Changed:= V_Changed;
  if Changed then StrPCopy(Title,'<'+FileName+'>')
             else StrPCopy(Title,FileName);
  SetCaption(Title);
end; end;

function    T_FileWindow.IsChanged: boolean;
begin IsChanged:= Changed; end;

procedure   T_FileWindow.ProcessItem (V_Row: integer);
begin DoEditChange; end;

function    T_FileWindow.ReadList(V_Name: T_PathStp): P_AbbList;
var p: P_AbbList;
begin
  p:= New(P_AbbList,Init);
  MergeList(V_Name,p);
  ReadList:= p;
end;

procedure   T_FileWindow.MergeList(V_Name: T_PathStp; V_List: P_AbbList);
  var F: Text; Line: String; ok: boolean; s: PString;
  procedure ErrMsg(V_Msg:String);
    var S: T_MsgStr;
    begin
      MessageBox(HWindow,StrPCopy(S,V_Msg+#13+V_Name),
	PrgName,mb_IconHand or mb_OK);
    end;
begin {T_FileWindow.MergeList}
  Assign(F,V_Name); {$I-} Reset(F); {$I+}
  if IOResult = 0 then begin
    ok:= true;
    while ok and not eof(F) do begin
      {$I-} readln(F,Line); {$I+}
      if IOResult = 0 then begin
	s:= NewStr(Line);
        if not V_List^.InsertNew(s) then DisposeStr(s);
      end
      else begin ok:= false; ErrMsg('Error reading file'); end;
    end;
    System.Close(F);
  end;
end;

procedure   T_FileWindow.WriteList(V_Name: T_PathStp; V_List: P_AbbList);
  var F: Text; Line: String; ok: boolean;
  procedure ErrMsg(V_Msg:String);
    var S: T_MsgStr;
    begin
      MessageBox(HWindow,StrPCopy(S,V_Msg+#13+V_Name),
        PrgName,mb_IconHand or mb_OK);
    end;
  procedure WriteItem(V_Item: Pointer); far;
    begin if ok then begin
      {$I-}Writeln(F,PString(V_Item)^);{$I+} ok:= IOResult=0;
    end; end;
begin {T_FileWindow.WriteList}
  Assign(F,V_Name); {$I-} Rewrite(F); {$I+}
  if IOResult <> 0 then ErrMsg('Open error')
  else begin
    ok:= true; V_List^.ForEach(@WriteItem);
    if ok then SetChanged(false) else ErrMsg('Write error');
    System.Close(F);
  end;
end;

function    T_FileWindow.CanClose: boolean;
var S: T_MsgStr; IsOK: boolean;
begin
  IsOK:= true;
  if IsChanged then begin
    case MessageBox(HWindow,StrPCopy(S,'Save changes?'#13#13+FileName),
      PrgName,mb_IconQuestion or mb_YesNoCancel) of
      IDYES    : begin DoFileSave; IsOK:= not IsChanged; end;
      IDNO     : IsOK:= true;
      IDCANCEL : IsOK:= false;
      else       IsOK:= false;
    end;
  end;
  CanClose:= IsOK and Inherited CanClose;
end;

procedure T_FileWindow.CMFileNew   (var V_Msg:TMessage);begin DoFileNew    end;
procedure T_FileWindow.CMFileOpen  (var V_Msg:TMessage);begin DoFileOpen   end;
procedure T_FileWindow.CMFileMerge (var V_Msg:TMessage);begin DoFileMerge  end;
procedure T_FileWindow.CMFileSave  (var V_Msg:TMessage);begin DoFileSave   end;
procedure T_FileWindow.CMFileSaveAs(var V_Msg:TMessage);begin DoFileSaveAs end;
procedure T_FileWindow.CMEditChange(var V_Msg:TMessage);begin DoEditChange end;
procedure T_FileWindow.CMEditAdd   (var V_Msg:TMessage);begin DoEditAdd    end;
procedure T_FileWindow.CMEditDelete(var V_Msg:TMessage);begin DoEditDelete end;
procedure T_FileWindow.CMFindKey   (var V_Msg:TMessage);begin DoFindKey    end;
procedure T_FileWindow.CMFindDescr (var V_Msg:TMessage);begin DoFindData   end;
procedure T_FileWindow.CMFindAgain (var V_Msg:TMessage);begin DoFindAgain  end;
procedure T_FileWindow.CMFindDupl  (var V_Msg:TMessage);begin DoFindDupl   end;
procedure T_FileWindow.CMBottom(var V_Msg:TMessage);begin SetCurRow(MaxRow)end;
procedure T_FileWindow.CMTop       (var V_Msg:TMessage);begin SetCurRow(0) end;
procedure T_FileWindow.WMAdjustCmds(var V_Msg:TMessage);begin DoAdjustCmds;end;

procedure T_FileWindow.DoAdjustCmds;
begin
  if (List=nil) or (List^.Count = 0) then
    AdjustEditCommands(false)
  else begin
    AdjustCommand(cm_EditChange      ,true);
    AdjustCommand(cm_EditDelete      ,true);
    AdjustCommand(cm_FindKey         ,true);
    AdjustCommand(cm_FindDescr       ,true);
    AdjustCommand(cm_FindAgain       ,LastFind <> lf_None);
    AdjustCommand(cm_FindDupl        ,List^.Count > 1);
  end;
end;

procedure   T_FileWindow.DoFileNew;
begin if CanClose then FileTerm; end;

procedure   T_FileWindow.DoFileOpen;
var Name: T_PathStr;
begin if CanClose then begin
  StrCopy(Name,C_DflOpenMask);
  if Application^.ExecDialog(New(PFileDialog,
    Init(@Self,MakeIntResource(sd_FileOpen),@Name))) = id_OK
  then begin
    FileTerm;
    FileName:= StrPas(@Name);
    NewList(ReadList(FileName));
    FileInit;
  end;
end; end;

procedure   T_FileWindow.DoFileMerge;
var Name: T_PathStr; OldCount: integer;
begin
  StrCopy(Name,C_DflOpenMask);
  if Application^.ExecDialog(New(P_MergeFileDlg,Init(@Self,@Name)))
  = id_OK then begin
    OldCount:= List^.Count;
    MergeList(StrPas(@Name),P_AbbList(List));
    if List^.Count > OldCount then begin
     SetChanged(true);
      InvalidateRect(HWindow,nil,true);
    end;
  end;
end;

procedure   T_FileWindow.DoFileSave   ;
begin if (List <> nil) and (List^.Count > 0) then begin
  if (FileName='') then DoFileSaveAs
  else begin WriteList(FileName,P_AbbList(List)); ReDraw; end;
end; end;

procedure   T_FileWindow.DoFileSaveAs ;
var Name: T_PathStr;
begin if (List <> nil) and (List^.Count > 0) then begin
  StrPCopy(Name,FileName);
  if Application^.ExecDialog(New(PFileDialog,
    Init(@Self,MakeIntResource(sd_FileSave),@Name))) = id_OK
  then begin
    FileName:= StrPas(Name);
    WriteList(FileName,P_AbbList(List));
    FileInit;
  end;
end; end;

procedure   T_FileWindow.DoEditAdd;
var Buf: T_AbbInfoRec; S: String; PS: PString; i: integer;
begin if List <> nil then begin
  StringToAbb('',Buf);
  if Application^.ExecDialog(New(P_EditAddDlg,Init(@Self,@Buf))) = id_OK
  then with Buf do begin
    S:= AbbToString(Buf); PS:= NewStr(S);
    if not P_AbbList(List)^.InsertNew(PS) then DisposeStr(PS);
    SetMaxRow(List^.Count-1);
    if P_AbbList(List)^.Search(@S,i) then SetCurRow(i) else SetCurRow(0);
    SetChanged(true); ReDraw;
  end;
end; end;

procedure   T_FileWindow.DoEditChange;
var Buf: T_AbbInfoRec; S0,S: String; PS: PString; i: integer;
begin if (List <> nil) and (List^.Count > 0) then begin
  S0:= PString(List^.At(CurRow))^;
  StringToAbb(S0,Buf);
  if Application^.ExecDialog(New(P_EditChgDlg,Init(@Self,@Buf))) = id_OK
  then with Buf do begin
    S:= AbbToString(Buf);
    if S <> S0 then begin
      DisposeStr(PString(List^.At(CurRow)));
      P_AbbList(List)^.AtDelete(CurRow);
      PS:= NewStr(S);
      if not P_AbbList(List)^.InsertNew(PS) then DisposeStr(PS);
      SetMaxRow(List^.Count-1);
      if P_AbbList(List)^.Search(@S,i) then SetCurRow(i) else SetCurRow(0);
      SetChanged(true); ReDraw;
    end;
  end;
end; end;

procedure   T_FileWindow.DoEditDelete;
var Buf: T_AbbInfoRec; S: String; i: integer;
begin if (List <> nil) and (List^.Count > 0) then begin
  StringToAbb(PString(List^.At(CurRow))^,Buf);
  if Application^.ExecDialog(New(P_EditDelDlg,Init(@Self,@Buf))) = id_OK
  then begin
    DisposeStr(PString(List^.At(CurRow))); P_AbbList(List)^.AtDelete(CurRow);
    SetMaxRow(List^.Count-1);
    SetChanged(true); ReDraw;
  end;
end; end;

procedure   T_FileWindow.DoFindKey;
var Buf: T_FindKeyBuf; S: String; i: integer;
begin if (List <> nil) and (List^.Count > 0) then begin
  with Buf do begin StrCopy(IO_Key,''); end;
  if Application^.ExecDialog(New(P_FindKeyDlg,Init(@Self,@Buf))) = id_OK
  then begin
    FindKey:= StrPas(Buf.IO_Key);
    S:= ' ' + FindKey; P_AbbList(List)^.Search(@S,i);
    SetCurRow(i); ReDraw;
    LastFind:= lf_Key;
  end;
end; end;

procedure   T_FileWindow.DoFindData;
var Buf: T_FindDataBuf; S: String; i: integer;
begin if (List <> nil) and (List^.Count > 0) then begin
  with Buf do begin StrCopy(IO_Data,''); end;
  if Application^.ExecDialog(New(P_FindDataDlg,Init(@Self,@Buf))) = id_OK
  then begin
    FindData:= StrPas(Buf.IO_Data);
    LastFind:= lf_Data;
    DoFindDataAgain;
  end;
end; end;

procedure   T_FileWindow.DoFindAgain;
begin case LastFind of
  lf_None: {do nothing} ;
  lf_Key : DoFindKeyAgain;
  lf_Data: DoFindDataAgain;
end end;

procedure   T_FileWindow.DoFindKeyAgain;
var CurKey: T_KeyStr; Found: boolean; i: integer; S: T_MsgStr;
begin if (List <> nil) and (List^.Count > 0) and (FindKey <> '') then begin
  Found:= false; i:= CurRow;
  while (not Found) and (i < List^.Count-1) do begin
    Inc(i);
    Found:=
      Pos(FindKey,Copy(PString(List^.At(i))^,C_KeyPos,C_KeyLen))=1;
  end;
  if Found then begin SetCurRow(i); ReDraw; end
  else MessageBox(HWindow,
    StrPCopy(S,
      #13'No entries matching "'+FindKey+
         '" found, starting at current row.'),
      PrgName,mb_IconInformation or mb_OK
  );
end; end;

procedure   T_FileWindow.DoFindDataAgain;
var CurData: T_DataStr; Found: boolean; i: integer; S: T_MsgStr;
begin if (List <> nil) and (List^.Count > 0) and (FindData <> '') then begin
  Found:= false; i:= CurRow;
  while (not Found) and (i < List^.Count-1) do begin
    Inc(i);
    Found:=
      Pos(FindData,Copy(PString(List^.At(i))^,C_DataPos,C_DataLen))>0;
  end;
  if Found then begin SetCurRow(i); ReDraw; end
  else MessageBox(HWindow,
    StrPCopy(S,
      #13'No descriptions containing "'+FindData+
	 '" found, starting at current row.'),
      PrgName,mb_IconInformation or mb_OK
  );
end; end;

procedure   T_FileWindow.DoFindDupl;
var CurKey, PrvKey: T_KeyStp; Found: boolean; i: integer;
begin if (List <> nil) and (List^.Count > 1) then begin
  Found:= false; i:= CurRow;
  PrvKey:= Copy(PString(List^.At(i))^,C_KeyPos,C_KeyLen);
  while (not Found) and (i < List^.Count-1) do begin
    Inc(i);
    CurKey:= Copy(PString(List^.At(i))^,C_KeyPos,C_KeyLen);
    if CurKey=PrvKey then Found:= true else PrvKey:= CurKey;
  end;
  if Found then begin SetCurRow(i); ReDraw; end
  else MessageBox(HWindow,
    #13'No duplicate keys found, starting at current row.',PrgName,
    mb_IconInformation or mb_OK
  );
end; end;


{ --- T_MainWindow --- }

Constructor T_MainWindow.Init(V_Title: PChar; V_Menu: HMenu);
begin
  Inherited Init(V_Title, V_Menu);
  ChildMenuPos:= 3; ChildCount:= 0;
end;

Destructor  T_MainWindow.Done;
begin SaveDeskTop; Inherited Done; end;

function    T_MainWindow.GetClassName: PChar;
begin GetClassName:= C_MainWindowClass; end;

procedure   T_MainWindow.GetWindowClass(var V_Class: TWndClass);
begin
  Inherited GetWindowClass(V_Class);
  V_Class.hIcon:= LoadIcon(HInstance,MakeIntResource(Ico_Main));
end;

function    T_MainWindow.InitChild: PWindowsObject;
begin InitChild:= New(P_FileWindow, Init(@Self)); end;

procedure   T_MainWindow.SetupWindow;
var FirstChild: P_FileWindow;
begin
  Inherited SetupWindow;
  if not LoadDeskTop then begin
    FirstChild:= P_FileWindow(InitChild);
    with FirstChild^.Attr do Style:= Style or ws_Maximize;
    Application^.MakeWindow(FirstChild);
  end;
end;

function    T_MainWindow.LoadDeskTop: boolean;
var
  Stream : TBufStream;
  ok     : boolean;
  InpTag : T_PathStr;
  Msg,S  : T_MsgStr;
begin
  ok:= false;
{$IFDEF AUTOSAVE}
  Stream.Init(SettingPath,stOpenRead,1024);
  if Stream.Status=stOK then StzCpy(InpTag,Stream.StrRead);
  if (Stream.Status=stOK) and (StzCmp(InpTag,SettingTag)=0)
  then begin
    CloseChildren;
    GetChildren(Stream);
    CreateChildren;
  end;
  Stream.Done;
  case Stream.Status of
    stOK       : ok:= true;
    stInitError: {file not found, just return false}
    else begin
      StzCat(StzcECat(StzECat(StzECpy(Msg,
        'Unable to load setup file'#13),
        SettingPath),#13),
        StzStpCpy(S,BPWStreamMsg(Stream)));
      MessageBox(HWindow,Msg,PrgName,mb_IconHand or mb_OK);
    end;
  end;
{$ENDIF}
  LoadDeskTop:= ok;
end;

procedure   T_MainWindow.SaveDeskTop;
var Stream: TBufStream; Msg,S: T_MsgStr;
begin
{$IFDEF AUTOSAVE}
  Stream.Init(SettingPath,stCreate,1024);
  Stream.StrWrite(SettingTag);
  PutChildren(Stream);
  Stream.Done;
  if Stream.Status <> StOK then begin
    StzCat(StzcECat(StzECat(StzECpy(Msg,
      'Unable to save setup file'#13),
      SettingPath),#13),
      StzStpCpy(S,BPWStreamMsg(Stream)));
    MessageBox(HWindow,Msg,PrgName,mb_IconHand or mb_OK);
  end;
{$ENDIF}
end;

procedure T_MainWindow.AdjustCommands;
var HChildWnd: Word;
begin
  if ChildCount = 0 then begin
    AdjustFileCommands(false);
    AdjustEditCommands(false);
  end
  else begin
    AdjustFileCommands(true);
    AdjustEditCommands(false);
    if ClientWnd<>nil then begin
      HChildWnd:= LoWord(SendMessage(ClientWnd^.HWindow,wm_MDIGetActive,0,0));
      if HChildWnd <> 0 then PostMessage(HChildWnd,wm_AdjustCmds,0,0);
    end;
  end;
end;

procedure T_MainWindow.CMFileNew    (var V_Msg:TMessage);begin DoFileNew     end;
procedure T_MainWindow.CMFileOpen   (var V_Msg:TMessage);begin DoFileOpen    end;
procedure T_MainWindow.CMFileSaveAll(var V_Msg:TMessage);begin DoFileSaveAll end;
procedure T_MainWindow.CMWinNew     (var V_Msg:TMessage);begin DoWinNew      end;
procedure T_MainWindow.CMHelpAbout  (var V_Msg:TMessage);begin DoHelpAbout   end;
procedure T_MainWindow.CMHelpInfo   (var V_Msg:TMessage);begin DoHelpInfo    end;

procedure T_MainWindow.DoFileNew    ; begin CreateChild; end;
procedure T_MainWindow.DoWinNew     ; begin CreateChild; end;

procedure T_MainWindow.DoFileOpen ;
var p: P_FileWindow;
begin p:= P_FileWindow(CreateChild); if p<>nil then p^.DoFileOpen; end;

procedure   T_MainWindow.DoFileSaveAll;
  procedure FileSave(p: PWindow); far;
  begin if p^.IsFlagSet(wb_MDIChild) then P_FileWindow(p)^.DoFileSave end;
begin {T_MainWindow.DoFileSaveAll} ForEach(@FileSave); end;

procedure   T_MainWindow.DoHelpAbout;
var Msg: T_MsgStr;
begin
  StzCat(StzECpy(Msg,
    PrgIdent),' - '+C_PrgTitle+#13+
    'MS-Windows'+#13+
    +C_CopyRight+#13+
    C_AuthEmail+#13+
    C_AuthURL);
  MessageBox(HWindow,Msg,'About this program',
    mb_IconInformation or mb_OK);
end;

procedure   T_MainWindow.DoHelpInfo;
begin
  MessageBox(HWindow,
    #13'View and maintain a list of abbrevations',
    PrgName,mb_IconInformation or mb_OK)
end;


{ --- T_Application --- }

procedure   T_Application.InitMainWindow;
begin
  MainWindow:= New(P_MainWindow,
    Init(C_PrgTitle,LoadMenu(HInstance,MakeIntResource(Mnu_Main))));
end;

procedure   T_Application.InitInstance;
begin
  Inherited InitInstance;
  HACCTable:= LoadAccelerators(HInstance,MakeIntResource(Acc_Keys));
end;

function    T_Application.IdleAction: boolean;
begin
  if MainWindow<>nil then P_MainWIndow(MainWindow)^.AdjustCommands;
  IdleAction:= Inherited IdleAction;
end;



{ --- Main program --- }

begin { Main program }
  GetDirs; StreamRegistration;
  Application:= New(P_Application, Init(PrgIdent));
  Application^.Run;
  Dispose(Application,Done);
end.
