/* TIMTST.C : Test op TIMLIB routines

   Title   : TIMTST
   Version : 5.0
   Date    : Nov 27,1996
   Author  : J.R. Ferguson
   Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
   Usage   : Test program

[ Project file:
timtst   (timlib.h,timtstm.h,timtstm1.h,timtstm2.h)
timlib   (timlib.h)
timtstm  (timtstm.h)
timtstm1 (timtstm1.h)
timtstm2 (timtstm2.h)
tcfd.lib
]
*/

#include <stdio.h>
#include "timlib.h"
#include "timtstm.h"
#include "timtstm1.h"
#include "timtstm1.h"

Tim_DateRec    date;
Tim_TimeRec    time;
long int       PackedDate;
long int       PackedTime;

#define  wrln()   printf("\n")
#define  wrln2()  printf("\n\n")


void errormessage(int ok)
{
  wrln();
  if (ok) printf("OK"); else printf("ERROR\x07");
  wrln();
}


void askdate(Tim_DateRec *date)
{ int d,m,j;

  printf("Day   (1..31)      : "); scanf("%i",&d); date->day   = d;
  printf("Month (1..12)      : "); scanf("%i",&m); date->month = m;
  printf("Year  (1980..2099) : "); scanf("%i",&j); date->year  = j;
}


void asktime(Tim_TimeRec *time)
{ int u,m,s,c;

  printf("Hours    (0..23) : "); scanf("%i",&u); time->hours    = u;
  printf("Minutes  (0..59) : "); scanf("%i",&m); time->minutes  = m;
  printf("Seconds  (0..59) : "); scanf("%i",&s); time->seconds  = s;
  printf("Centisec (0..99) : "); scanf("%i",&c); time->centisec = c;
}


void asklongint(long int *n)
{ printf("n: "); scanf("%li",n); }


void writedate(const Tim_DateRec *date)
{
  printf("date (dd-mm-yyyy)  = %02i-%02i-%04i\n",
          date->day,
          date->month,
          date->year);
}


void writetime(const Tim_TimeRec *time)
{
  printf("time (hh:mm:ss,cc) = %02i:%02i:%02i,%02i\n",
          time->hours,
          time->minutes,
          time->seconds,
          time->centisec);
}


/* void writelongint(long int n) */
#define  writelongint(n)    printf("n=%li\n",n);


void xPackDate(void)
{
  wrln2();
  askdate(&date);
  errormessage(Tim_PackDate(&date,&PackedDate));
  writelongint(PackedDate);
  errormessage(Tim_UnpackDate(PackedDate,&date));
  writedate(&date);
  wrln2();
}


void xPackTime(void)
{
  wrln2();
  asktime(&time);
  errormessage(Tim_PackTime(&time,&PackedTime));
  writelongint(PackedTime);
  errormessage(Tim_UnpackTime(PackedTime,&time));
  writetime(&time);
  wrln2();
}


void xUnpackDate(void)
{
  wrln2();
  asklongint(&PackedDate);
  errormessage(Tim_UnpackDate(PackedDate,&date));
  writedate(&date);
  errormessage(Tim_PackDate(&date,&PackedDate));
  writelongint(PackedDate);
  wrln2();
}


void xUnpackTime(void)
{
  wrln2();
  asklongint(&PackedTime);
  errormessage(Tim_UnpackTime(PackedTime,&time));
  writetime(&time);
  errormessage(Tim_PackTime(&time,&PackedTime));
  writelongint(PackedTime);
  wrln2();
}


void xGetDateTime(void)
{
  wrln2();
  Tim_GetDate(&date); writedate(&date);
  Tim_GetTime(&time); writetime(&time);
  wrln2();
}


void xSetDate(void)
{
  wrln2();
  askdate(&date);
  errormessage(Tim_SetDate(&date));
  xGetDateTime();
}


void xSetTime(void)
{
  wrln2();
  asktime(&time);
  errormessage(Tim_SetTime(&time));
  xGetDateTime();
}


int main(void)
{ timtstm(); return 0; }
