/* TIMLIB.H : Time/Date routines

   Title   : TIMLIB
   Version : 5.0
   Date    : Nov 27,1996
   Author  : J.R. Ferguson
   Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
   Usage   : Header file
*/

/*.hlptx skip 1*/
#ifndef Tim_Lib
#define Tim_Lib

typedef struct {
          unsigned int   year    ; /* 1980..2099 */
          unsigned char  month   ; /* 1..12      */
          unsigned char  day     ; /* 1..31      */
        } Tim_DateRec;

typedef struct {
          unsigned char  hours   ; /* 0..23 */
          unsigned char  minutes ; /* 0..59 */
          unsigned char  seconds ; /* 0..59 */
          unsigned char  centisec; /* 0..99 hundreths of a second */
        } Tim_TimeRec;

/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

int Tim_PackDate(const Tim_DateRec *date, long int *n);
/* Pack date. Function result is 1 if successful, 0 if not. */

int Tim_PackTime(const Tim_TimeRec *time, long int *n);
/* Pack time. Function result is 1 if successful, 0 if not. */

int Tim_UnpackDate(long int n, Tim_DateRec *date);
/* Unpack date. Function result is 1 if successful, 0 if not. */

int Tim_UnpackTime(long int n, Tim_TimeRec *time);
/* Unpack time. Function result is 1 if successful, 0 if not. */

void Tim_GetDate(Tim_DateRec *date);
/* Get current system date. */

int Tim_SetDate(const Tim_DateRec *date);
/* Set system date. If the date parameter holds an invalid date, the
   function result will be 0 and the system date is not altered.
   If the function succeeds, the function result is 1.
*/

void Tim_GetTime(Tim_TimeRec *time);
/* Get current system time. */

int Tim_SetTime(const Tim_TimeRec *time);
/* Set system time. If the time parameter holds invalid time information,
   the function result will be 0 and the system time is not altered.
   If the function succeeds, the function result is 1.
*/

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* #ifndef Tim_Lib */
