/* TIMLIB.C : Time/Date routines

   Title   : TIMLIB
   Version : 5.0
   Date    : Nov 27,1996
   Author  : J.R. Ferguson
   Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
   Usage   : Function library
*/

#include <dos.h>
#include "timlib.h"
#include "dtmlib.h"

int Tim_PackDate(const Tim_DateRec *date, long int *n)
{ Dtm_DateRec dtm;

  dtm.fn        = Dtm_FNYMD;
  dtm.ymd.year  = date->year;
  dtm.ymd.month = date->month;
  dtm.ymd.day   = date->day;
  if (Dtm_Convert(&dtm)) { *n= dtm.idf; return 1; }
  else return 0;
}


int Tim_PackTime(const Tim_TimeRec *time, long int *n)
{
  *n= (long int)time->hours    * 360000 +
      (long int)time->minutes  * 6000   +
      (long int)time->seconds  * 100    +
      (long int)time->centisec;
  return 1;
}


int Tim_UnpackDate(long int n, Tim_DateRec *date)
{ Dtm_DateRec dtm;

  dtm.fn = Dtm_FNIDF;
  dtm.idf= n;
  if (Dtm_Convert(&dtm)) {
    if ((dtm.ymd.year >= 1980) && (dtm.ymd.year <= 2099)) {
      date->year   = dtm.ymd.year;
      date->month  = dtm.ymd.month;
      date->day    = dtm.ymd.day;
      return 1;
    }
  }
  return 0;
}


int Tim_UnpackTime(long int n, Tim_TimeRec *time)
{
  if ( (n >= 0) && (n < 8640000) ) {
    time->centisec = n % 100; n /= 100;
    time->seconds  = n %  60; n /=  60;
    time->minutes  = n %  60;
    time->hours    = n /  60;
    return 1;
  }
  else return 0;
}


void Tim_GetDate(Tim_DateRec *date)
{ static union REGS cpu = { 0x2A00 };

  intdos(&cpu,&cpu);
  date->year  = cpu.x.cx;
  date->month = cpu.h.dh;
  date->day   = cpu.h.dl;
}


int Tim_SetDate(const Tim_DateRec *date)
{ static union REGS cpu = { 0x2B00 };

  cpu.x.cx = date->year;
  cpu.h.dh = date->month;
  cpu.h.dl = date->day;
  intdos(&cpu,&cpu);
  return cpu.h.al == 0;
}


void Tim_GetTime(Tim_TimeRec *time)
{ static union REGS cpu = { 0x2C00 };

  intdos(&cpu,&cpu);
  time->hours    = cpu.h.ch;
  time->minutes  = cpu.h.cl;
  time->seconds  = cpu.h.dh;
  time->centisec = cpu.h.dl;
}


int Tim_SetTime(const Tim_TimeRec *time)
{ static union REGS cpu = { 0x2D00, 0x0000, 0x0000, 0x0000 };

  cpu.h.ch = time->hours;
  cpu.h.cl = time->minutes;
  cpu.h.dh = time->seconds;
  intdos(&cpu,&cpu);
  return cpu.h.al == 0;
}
