/* STZTST.C - Test STZLIB

  Title   : STZTST
  Version : 1.5
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Date    : Nov 24,1996
  Author  : J.R. Ferguson
  Usage   : Test program

[ Project file:
stztst.c (stzlib.h stztstm.h stztstm1.h stztstm2.h stztstm3.h)
stzlib.c (stzlib.h)
tcfd.lib
]
*/

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "stztstm.h"
#include "stztstm1.h"
#include "stztstm2.h"
#include "stztstm3.h"
#include "stzlib.h"
#include "chrlib.h"

union   { char stp[256];
          struct { unsigned char n; char c[255]; } struc;
        } s0;

char    s1[256];
char    s2[256];
char    s3[256];
char    c;
char    inpbuf[80];
Stz_Ind n,i;
Stz_Ptr p;

void wrln2(void) { printf("\n\n"); }

int rdindex(Stz_Ind *n)
{ int i=0; char *inp=NULL;

  do inp= gets(inpbuf);
  while ((inp != NULL) && (sscanf(inp,"%i",&i) != 1) && (i>=0) && (i<=127) );
  if (inp == NULL) return 0; else { *n= i; return 1; }
}

void rdkar(void)
{
  printf("Character : ");
  c= getche();
  printf("\n");
}

void rdn(void)   { do printf("n = "); while (!rdindex(&n)); }
void rdpos(void) { do printf("position = "); while (!rdindex(&i)); }

void rd1stz(void)
{ printf("\n\nEnter string\n:"); gets(s1); }

void rd2stz(void)
{
  wrln2();
  printf("Enter string 1\n:"); gets(s1);
  printf("Enter string 2\n:"); gets(s2);
}

void rdstp(void)
{ char s[256]; Stz_Ind i;

  wrln2();
  printf("Enter string\n:"); gets(s);
  s0.struc.n= strlen(s);
  for (i=0; i<s0.struc.n; ++i) s0.struc.c[i]= s[i];
}

void wrkar(char c)
{ printf("c = '%c' (%u)\n",c,c); }

void wrstp(void)
{ unsigned char i;

  printf("'");
  for (i=0; i<s0.struc.n; ++i) printf("%c",s0.struc.c[i]);
  printf("'\n");
}

void wrstz(const Stz_Ptr s) { printf("\"%s\"\n",s); }

void wrstzcnd(Stz_Ptr s)
{ if (s==NULL) printf("NULL\n"); else printf("\"%s\"\n",s); }

void wrstzptr(Stz_Ptr s, Stz_Ptr p)
{ Stz_Ptr p1; Stz_Ind i,j,n;

  wrstzcnd(s);
  if (s != NULL) {
    if (p == NULL) printf("pointer = NULL, position unknown\n");
    else {
      for (p1=s,i=0,n=strlen(s); (p1<p) && (i<n) && (*p1); ++p1,++i);
      if (p1 == p) {
        for (j=i+1; j>0; --j) printf(" "); printf("*\n");
	printf("pointer position = %i\n",i);
      }
      else printf("pointer outside string, position unknown\n");
    }
  }
}

void wrstzpos(void)
{ int j;

  if (i==Stz_NOTFOUND) printf("not found\n");
  else {
    wrstzcnd(s1);
    for (j=i+1; j>0; --j) printf(" "); printf("^\n");
    printf ("index position = %u\n", i);
  }
}

void wrcmp(int result)
{
  printf("string 1 ");
  if      (result<0)  printf("<");
  else if (result==0) printf("=");
  else                printf(">");
  printf(" string 2\n");
}

void wrcnd(int condition)
{
  if (condition) printf("TRUE\n");
  else printf("FALSE\n");
}

void xAfter(void)    { rd2stz();wrstz(Stz_After(s1,s2)); }
void xAlloc(void)    { rd2stz();wrstzcnd(p=Stz_Alloc(s1));
                                wrstzcnd(Stz_ReAlloc(&p,s2));
                                Stz_Free(&p);wrstzcnd(p); }
void xBefore(void)   { rd2stz();wrstz(Stz_Before(s3,s1,s2)); }
void xCat(void)      { rd2stz();wrstz(Stz_Cat(s1,s2)); }
void xCenter(void)   { rd1stz();rdn();wrstz(Stz_Center(s1,n));}
void xCmp(void)      { rd2stz();wrcmp(Stz_Cmp(s1,s2)); }
void xCpy(void)      { rd1stz();wrstz(Stz_Cpy(s2,s1)); }
void xCreate(void)   { wrln2() ;wrstz(Stz_Create(s1)); }
void xDel(void)      { rd1stz();rdpos();rdn();wrstz(Stz_Del(s1,i,n)); }
void xECat(void)     { rd2stz();p=Stz_ECat(s1,s2);wrstzptr(s1,p); }
void xECpy(void)     { rd1stz();p=Stz_ECpy(s2,s1);wrstzptr(s2,p); }
void xEmpty(void)    { rd1stz();printf("StzEmpty=%i",Stz_Empty(s1)); }
void xEnd(void)      { rd1stz();p=Stz_End(s1);wrstzptr(s1,p); }
void xEntab(void)    { rd1stz();rdn();wrstz(s1);wrstz(Stz_Entab(s2,s1,n));
                                      wrstz(Stz_Detab(s3,s2,n)); }
void xFill(void)     { rd1stz();rdkar();rdn();wrstz(Stz_Fill(s1,c,n)); }
void xGtw(void)      { rd1stz();wrstz(s1);wrstz(Stz_Gtw(s2,s1));wrstz(s1); }
void xIns(void)      { rd2stz();rdpos();wrstz(Stz_Ins(s1,s2,i)); }
void xIPos(void)     { rd2stz();i=Stz_IPos(s1,s2);wrstzpos(); }
void xUppIPos(void)  { rd2stz();i=Stz_UppIPos(s1,s2);wrstzpos(); }
void xLen(void)      { rd1stz();wrstz(s1);printf("l = %u\n",Stz_Len(s1)); }
void xLexCmp(void)   { rd2stz();wrcmp(Stz_LexCmp(s1,s2)); }
void xLexNCmp(void)  { rd2stz();rdn();wrcmp(Stz_LexNCmp(s1,s2,n)); }
void xLexSrt(void)   { rd1stz();rdn();wrstz(Stz_LexSrt(s2,s1,n)); }
void xLow(void)      { rd1stz();wrstz(Stz_Low(s1)); }
void xMake(void)     { wrln2();rdkar();rdn();wrstz(Stz_Make(s1,c,n)); }
void xNCat(void)     { rd2stz();rdn();wrstz(Stz_NCat(s1,s2,n)); }
void xNCmp(void)     { rd2stz();rdn();wrcmp(Stz_NCmp(s1,s2,n)); }
void xNCpy(void)     { rd1stz();rdn();wrstz(Stz_NCpy(s2,s1,n)); }
void xNIns(void)     { rd2stz();rdpos();rdn();wrstz(Stz_NIns(s1,s2,i,n)); }
void xNRepl(void)    { rd2stz();rdpos();rdn();wrstz(Stz_NRepl(s1,s2,i,n)); }
void xPos(void)      { rd2stz();wrstzcnd(Stz_Pos(s1,s2)); }
void xRLS(void)      { rd1stz();wrstz(s1);wrstz(Stz_RLS(s1)); }
void xRTS(void)      { rd1stz();wrstz(s1);wrstz(Stz_RTS(s1)); }
void xRAS(void)      { rd1stz();wrstz(s1);wrstz(Stz_RAS(s1)); }
void xRepl(void)     { rd2stz();rdpos();wrstz(Stz_Repl(s1,s2,i)); }
void xRev(void)      { rd1stz();wrstz(s1);wrstz(Stz_Rev(s1)); }
void xRight(void)    { rd1stz();rdn();wrstz(Stz_Right(s1,n)); }
void xRIPos(void)    { rd2stz();i=Stz_RIPos(s1,s2);wrstzpos(); }
void xRPos(void)     { rd2stz();wrstzcnd(Stz_RPos(s1,s2)); }
void xSrt(void)      { rd1stz();rdn();wrstz(Stz_Srt(s2,s1,n)); }
void xStpCpy(void)   { rdstp();wrstp();wrstz(Stz_StpCpy(s1,s0.stp)); }
void xSoundAlike(void) { rd2stz(); rdpos();
  printf("Stz_SoundAlike: ");wrcnd(Stz_SoundAlike(s1,s2,i)); }
void xSoundEx(void)  { rd1stz(); rdpos(); wrstz(Stz_SoundEx(s2,s1,i)); }
void xSub(void)      { rd1stz();rdpos();rdn();wrstz(Stz_Sub(s2,s1,i,n)); }
void xTrunc(void)    { rd1stz();rdn();wrstz(Stz_Trunc(s1,n)); }
void xUpp(void)      { rd1stz();wrstz(Stz_Upp(s1)); }
void xUppCmp(void)   { rd2stz();wrcmp(Stz_UppCmp(s1,s2)); }
void xUppNCmp(void)  { rd2stz();rdn();wrcmp(Stz_UppNCmp(s1,s2,n)); }
void xUppPos(void)   { rd2stz();wrstzcnd(Stz_UppPos(s1,s2)); }
void xUppRIPos(void) { rd2stz();i=Stz_UppRIPos(s1,s2);wrstzpos(); }
void xUppRPos(void)  { rd2stz();wrstzcnd(Stz_UppRPos(s1,s2)); }
void xUppSrt(void)   { rd1stz();rdn();wrstz(Stz_UppSrt(s2,s1,n)); }

void xcCat(void)     { rd1stz();rdkar();wrstz(Stz_cCat(s1,c)); }
void xcCpy(void)     { wrln2();rdkar();wrstz(Stz_cCpy(s1,c));  }
void xcECat(void)    { rd1stz();rdkar();p=Stz_cECat(s1,c);wrstzptr(s1,p); }
void xcECpy(void)    { wrln2();rdkar();p=Stz_cECpy(s1,c);wrstzptr(s1,p); }
void xcGet(void)     { rd1stz();wrkar(Stz_cGet(s1));wrstz(s1); }
void xcIns(void)     { rd1stz();rdkar();rdpos();wrstz(Stz_cIns(s1,c,i)); }
void xcIPos(void)    { rd1stz();rdkar();i=Stz_cIPos(s1,c);wrstzpos(); }
void xcPos(void)     { rd1stz();rdkar();wrstzcnd(Stz_cPos(s1,c)); }
void xcRIPos(void)   { rd1stz();rdkar();i=Stz_cRIPos(s1,c);wrstzpos(); }
void xcRPos(void)    { rd1stz();rdkar();wrstzcnd(Stz_cRPos(s1,c)); }
void xcUppIPos(void) { rd1stz();rdkar();i=Stz_cUppIPos(s1,c);wrstzpos(); }
void xcUppPos(void)  { rd1stz();rdkar();wrstzcnd(Stz_cUppPos(s1,c)); }
void xcUppRIPos(void){ rd1stz();rdkar();i=Stz_cUppRIPos(s1,c);wrstzpos(); }
void xcUppRPos(void) { rd1stz();rdkar();wrstzcnd(Stz_cUppRPos(s1,c)); }
void xcRet(void)     { rd1stz();rdpos();wrkar(Stz_cRet(s1,i)); }
void xcUpd(void)     { rd1stz();rdkar();rdpos();wrstz(Stz_cUpd(s1,c,i)); }
                     
#include "stztstm.c"
#include "stztstm1.c"
#include "stztstm2.c"
#include "stztstm3.c"

int main(void)
{
  stztstm();
  printf("Exit\n");
  return 0;
}
