/* SRTTSTW.CPP - Test SRTLIB (Windows version)

  Title   : SRTTSTW
  Version : 2.1
  Date    : Nov 27,1996
  Author  : J R Ferguson
  Language: Turbo C++ 3.1 for Windows
  Target  : MS-Windows 3.1
  Usage   : MS-Windows 3.1 application
*/

#undef  DEBUG
#define WIN31

#include <stdlib.h>
#include <stdio.h>
#include <owl.h>
#include <owldefs.h>
#include <windobj.h>
#include <dialog.h>
#include <radiobut.h>
#include "srtlib.h"
#include "srttstw.h"

#define  C_ApplIdn   "SRTTSTW"
#define  C_Count     100
#define  C_MaxValue  1000

typedef  int           *P_Int;
typedef  enum {C_SortInsert,C_SortSelect,C_SortQuick}
                       T_SortMethod;
typedef  unsigned int  T_DataInd;
typedef  int           T_Data[C_Count];
typedef  T_Data        *PT_Data;

_CLASSDEF(T_MainDlgBuf)
struct T_MainDlgBuf {
   BOOL IO_SortInsert;
   BOOL IO_SortSelect;
   BOOL IO_SortQuick;
};

_CLASSDEF(T_MainWindow)
class T_MainWindow : public TDialog
{
public:
  T_SortMethod  SortMethod;
  PT_Data       Before, After;
#ifdef DEBUG
  PT_MainDlgBuf IOBuf;
#endif
                T_MainWindow(void);
  virtual       ~T_MainWindow(void);
  virtual LPSTR GetClassName(void);
  virtual void  GetWindowClass(WNDCLASS&);
  virtual void  SetupWindow(void);
  void          DataInit(void);
  void          DataTerm(void);
  virtual void  IDNewData(void)= [ID_FIRST + id_NewData];
  virtual void  IDSort   (void)= [ID_FIRST + id_Sort   ];
private:
  void          DlgInit(void);
  void          DlgTerm(void);
  void          DlgImport(void);
  void          DlgExport(void);
};

_CLASSDEF(T_Application)
class T_Application : public TApplication
{
public:
                T_Application(LPSTR V_Name, HINSTANCE V_Instance,
                              HINSTANCE V_PrevInstance, LPSTR V_CmdLine,
                              int V_CmdShow)
               :TApplication (V_Name,V_Instance,V_PrevInstance,V_CmdLine,
                              V_CmdShow) {};
  virtual void  InitMainWindow(void);
  virtual void  InitInstance(void);
  virtual BOOL  ProcessAppMsg(LPMSG V_Mag);
};


/* --- General routines --- */

void InitData(PT_Data V_Data)
{ T_DataInd i;

  randomize();
  for (i= 0; i<C_Count; ++i)
    (*V_Data)[i]= random(C_MaxValue);
}

void CopyData(PT_Data V_Dst, const PT_Data V_Src)
{ T_DataInd i;

  for (i= 0; i<C_Count; ++i)
    (*V_Dst)[i]= (*V_Src)[i];
}

int CompareData(const Srt_ElmPtr e1, const Srt_ElmPtr e2)
{
#ifdef DEBUG
  int n1, n2, result;

  n1= *((P_Int)e1);
  n2= *((P_Int)e2);
  result= n1-n2;
  return result;
#else
  return *((P_Int)e1) - *((P_Int)e2);
#endif
}

void SortData(T_SortMethod V_SortMethod, PT_Data V_Dst)
{ switch (V_SortMethod) {
  case C_SortInsert:
       Srt_BinIns(*V_Dst,C_Count,sizeof(int),CompareData);
       break;
  case C_SortSelect:
       Srt_Select(*V_Dst,C_Count,sizeof(int),CompareData);
       break;
  case C_SortQuick :
       Srt_Quick (*V_Dst,C_Count,sizeof(int),CompareData);
       break;
} }


/* --- T_MainWindow --- */

T_MainWindow::T_MainWindow(void)
: TDialog(NULL,DLG_MAINWINDOW)
{
  DataInit();
  DlgInit();
}

T_MainWindow::~T_MainWindow(void)
{
  DlgTerm();
  DataTerm();
}

LPSTR T_MainWindow::GetClassName(void)
{ return "SRTTSTWMAIN"; }

void   T_MainWindow::GetWindowClass(WNDCLASS& V_WndClass)
{ TDialog::GetWindowClass(V_WndClass); }

void   T_MainWindow::SetupWindow(void)
{
  TDialog::SetupWindow();
  DlgImport();
}

void   T_MainWindow::DataInit(void)
{
  SortMethod= C_SortInsert;
  Before= (PT_Data)malloc(sizeof(T_Data));
  After = (PT_Data)malloc(sizeof(T_Data));
  InitData(Before);
  CopyData(After,Before);
}

void   T_MainWindow::DataTerm(void)
{
  free(Before); Before= NULL;
  free(After) ; After = NULL;
}

void   T_MainWindow::DlgInit(void)
{ 
  new TRadioButton(this,id_SortInsert,NULL);
  new TRadioButton(this,id_SortSelect,NULL);
  new TRadioButton(this,id_SortQuick ,NULL);
#ifdef DEBUG
  SetTransferBuffer(IOBuf= new T_MainDlgBuf);
#else
  SetTransferBuffer(new T_MainDlgBuf);
#endif
}

void   T_MainWindow::DlgTerm(void)
{
  delete TransferBuffer; TransferBuffer= NULL;
#ifdef DEBUG
  IOBuf= NULL;
#endif
}

void   T_MainWindow::DlgImport(void)
{ T_DataInd i; char ItemStr[4];

  ((PT_MainDlgBuf)TransferBuffer)->IO_SortInsert= (SortMethod == C_SortInsert);
  ((PT_MainDlgBuf)TransferBuffer)->IO_SortSelect= (SortMethod == C_SortSelect);
  ((PT_MainDlgBuf)TransferBuffer)->IO_SortQuick = (SortMethod == C_SortQuick );
  TransferData(TF_SETDATA);
  SendDlgItemMsg(id_ListBefore,LB_RESETCONTENT,0,0);
  SendDlgItemMsg(id_ListAfter ,LB_RESETCONTENT,0,0);
  for (i= 0; i< C_Count; ++i) {
    sprintf(ItemStr,"%3i",(*Before)[i]);
    SendDlgItemMsg(id_ListBefore,LB_ADDSTRING,0,(LONG)ItemStr);
    sprintf(ItemStr,"%3i",(*After)[i]);
    SendDlgItemMsg(id_ListAfter ,LB_ADDSTRING,0,(LONG)ItemStr);
  }
}

void   T_MainWindow::DlgExport(void)
{
  TransferData(TF_GETDATA);
  if (((PT_MainDlgBuf)TransferBuffer)->IO_SortInsert) SortMethod= C_SortInsert;
  if (((PT_MainDlgBuf)TransferBuffer)->IO_SortSelect) SortMethod= C_SortSelect;
  if (((PT_MainDlgBuf)TransferBuffer)->IO_SortQuick ) SortMethod= C_SortQuick ;
}

void   T_MainWindow::IDNewData(void)
{
  DlgExport();
  InitData(Before);
  CopyData(After,Before);
  DlgImport();
}

void   T_MainWindow::IDSort(void)
{
#ifdef DEBUG
  char Msg[127];
#endif
  
  DlgExport();
#ifdef DEBUG
  sprintf(Msg,"SortMethod = %i",SortMethod);
  MessageBox(HWindow,Msg,"Result of dialog export",MB_OK);
#endif
  CopyData(After,Before);
  SortData(SortMethod,After);
  DlgImport();
}


/* --- T_Application --- */

void T_Application::InitMainWindow(void)
{ MainWindow= new T_MainWindow(); }

void T_Application::InitInstance(void)
{ TApplication::InitInstance(); }

BOOL T_Application::ProcessAppMsg(LPMSG V_Msg)
/* Changed order of message processing because main window is a TDialog. */
{
  return ProcessAccels(V_Msg) ||
         ProcessDlgMsg(V_Msg) ||
         ProcessMDIAccels(V_Msg);
}

/* --- Main program  --- */

int PASCAL WinMain(HINSTANCE V_Instance, HINSTANCE V_PrevInstance,
  LPSTR V_CmdLine, int V_CmdShow)
{
  T_Application G_Application(C_ApplIdn, V_Instance, V_PrevInstance,
    V_CmdLine, V_CmdShow);
  G_Application.Run();
  return G_Application.Status;
}
