/* SRTLIB.H : In-memory array sort routines

   Title   : SRTLIB
   Version : 2.1
   Date    : Nov 27,1996
   Author  : J R Ferguson
   Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
   Usage   : Header file
*/

/*.hlptx skip 1*/
#ifndef Srt_Lib
#define Srt_Lib

#include <stdlib.h>

#define Srt_ElmPtr void *   /* Element pointer    */
#define Srt_SizTyp size_t   /* Element size type  */
#define Srt_IndTyp size_t   /* Element index type */

/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

typedef int     (Srt_CmpFnc) (const Srt_ElmPtr, const Srt_ElmPtr);
/* 
  Compare function
  return value <  0 if element 1 <  element 2
               == 0 if element 1 == element 2
               >  0 if element 1 >  element 2
*/


void Srt_Select(Srt_ElmPtr base,   /* pointer to first array element */
                Srt_IndTyp count,  /* number of elements to sort     */
                Srt_SizTyp size,   /* size of array elements to sort */
                Srt_CmpFnc *cmp);  /* compare function               */
/*
  Selection sort.

  Sorts count elements of given size at adjacent memory addresses within
  a (64k - 16) byte range starting at base, using the ordering as defined
  by the cmp function.

  Stable, natural. Minimizes the number of moves.
*/


void Srt_BinIns(Srt_ElmPtr base,   /* pointer to first array element */
                Srt_IndTyp count,  /* number of elements to sort     */
                Srt_SizTyp size,   /* size of array elements to sort */
                Srt_CmpFnc *cmp);  /* compare function               */
/*
  Binary search insertion sort.

  Sorts count elements of given size at adjacent memory addresses within
  a (64k - 16) byte range starting at base, using the ordering as defined
  by the cmp function.

  Stable, natural (quasi uniform). Minimizes number of compares.
  Preferable in most cases.
*/


#define Srt_Quick(base,count,size,cmp) qsort((base),(count),(size),(cmp))
/*
  void Srt_Quick (Srt_ElmPtr base,      pointer to first array element
                  Srt_IndTyp count,     number of elements to sort
                  Srt_SizTyp size,      size of array elements to sort
                  Srt_CmpFnc *cmp);     compare function

  Quicksort.

  Sorts count elements of given size at adjacent memory addresses within
  a (64k - 16) byte range starting at base, using the ordering as defined
  by the cmp function.

  Non-stable, uniform. Minimizes the number of both compares and moves,
  but has a significant housekeeping overhead and needs lots of stack.
  May be preferable when size is big and compares are slow, in particular
  when initial ordering may be (almost) reverse.
*/

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* #idndef Srt_Lib */
