/* SRTLIB.C : In-memory array sort routines

   Title   : SRTLIB
   Version : 2.0
   Date    : Nov 27,1996
   Author  : J R Ferguson
   Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
   Usage   : Function library
*/

#include <stdlib.h>
#include <mem.h>
#include "srtlib.h"


void Srt_Select(Srt_ElmPtr base,
                Srt_IndTyp count,
                Srt_SizTyp size,
                Srt_CmpFnc *cmp)
{
  char *p, *p0, *p1, *p2, *last;

  if ( (count > 1) && ((p= malloc(size)) != NULL) ) {
    last= (char *)base + (count-1)*size;
    p0  = base;
    while (p0 <= last) {
      p2= p0; p1= p2;
      while (p1 < last) {
        p1 += size;
        if (cmp(p1,p2) < 0) p2= p1;
      }
      if (p2 != p0) {
        memmove(p ,p0,size);
        memmove(p0,p2,size);
        memmove(p2,p ,size);
      }
      p0 += size;
    }
    free(p);
  }
}


void Srt_BinIns(Srt_ElmPtr base,
                Srt_IndTyp count,
                Srt_SizTyp size,
                Srt_CmpFnc *cmp)
{
  size_t i,l,r,m;
  char   *p;

  if ( (count > 1) && ((p= malloc(size)) != NULL) ) {
    i= 0;
    while (++i < count) {
      memmove(p,(char *)base + i*size, size);
      l= 0; r= i;
      do {
	m= l + (r - l) / 2;
	if (cmp((char *)base + m*size, p) > 0) r= m;
	else l= m+1;
      } while (l < r);
      if (l < i) {
	memmove ((char *)base + (l+1)*size,
		 (char *)base + l*size,
		 (i-l)*size
		);
	memmove ((char *)base + l*size, p, size);
      }
    }
    free(p);
  }
}
