// SLLTST.CPP : Test SLLLIB
//
// Title    : SLLTST
// Version  : 2.1
// Date     : nOV 27,1994
// Author   : J R Ferguson
// Language : Turbo C++ v3.1 for Windows
// Usage    : Test program

#include <stdlib.h>
#include <stdio.h>
#include "slllib.h"
#include "slltstm.h"
#include "conlib.h"

#define  wl() printf("\n")

#define  MaxItem  10

typedef struct {
  char key;
  int  nr ;
  int  seq;
} T_TestItem;

typedef T_TestItem *PT_TestItem;

_CLASSDEF(T_List);
class T_List : public T_Sll_List
{
public:
  T_List(void) : T_Sll_List() {};
  virtual void  FreeItem(void *V_Item);
};

_CLASSDEF(T_Stack);
class T_Stack : public T_Sll_Stack
{
public:
  T_Stack(void) : T_Sll_Stack() {};
  virtual void  FreeItem(void *V_Item);
};

_CLASSDEF(T_OrdList);
class T_OrdList : public T_Sll_OrdList
{
public:
  T_OrdList(PT_CompareFunc V_CompareFunc)
  : T_Sll_OrdList(V_CompareFunc) {};
  virtual void  FreeItem(void *V_Item);
};

T_TestItem   Before[MaxItem];
T_TestItem   After [MaxItem];
PT_Sll_List  List;

void T_List::FreeItem(void *V_Item)
{ delete (PT_TestItem)V_Item; }

void T_Stack::FreeItem(void *V_Item)
{ delete (PT_TestItem)V_Item; }

void T_OrdList::FreeItem(void *V_Item)
{ delete (PT_TestItem)V_Item; }

int Compare(const void *V_Item1, const void *V_Item2)
{ return ((PT_TestItem)(V_Item1))->key - ((PT_TestItem)V_Item2)->key; }

void TestInit(void)
{ int i;

  randomize();
  for (i= 0; i<MaxItem; ++i) {
    Before[i].nr= i+1; Before[i].seq= 0; Before[i].key= 'a' + random(26);
    After[i].nr= 0; After[i].seq= 0; After[i].key= ' ';
  }
}

void TestDisplay(void)
{ int i;

  wl(); wl();
  printf("INSERTED     RETRIEVED\n");
  printf("key nr seq   key nr seq\n");
  printf("--- -- ---   --- -- ---\n");
  for (i= 0; i < MaxItem; ++i) {
    printf("%2c  %2i  %2i   %2c  %2i  %2i\n",
           Before[i].key,Before[i].nr,Before[i].seq,
           After[i].key,After[i].nr,After[i].seq);
  }
  printf("--- -- ---   --- -- ---\n");
}

int Count;
void Number(const void *V_Item)
{ ((PT_TestItem)V_Item)->seq= ++Count; }

void TestList(PT_Sll_List V_List)
{ int i; PT_TestItem item;

  TestInit();
  for (i= 0; i < MaxItem; ++i ) {
    item= new T_TestItem; *item= Before[i];
    V_List->Insert(item);
  }
  Count= 0; V_List->ForEach(Number);
  for (i= 0; i < MaxItem; ++i) After[i]= *((PT_TestItem)(V_List->Retrieve()));
  TestDisplay(); printf("Empty = %i\n",V_List->Empty()); wl(); Con_WaitCR();
}


void xList(void)
{
  List= new T_List;
  TestList(List);
  delete List;
}

void xStack(void)
{
  List= new T_Stack;
  TestList(List);
  delete List;
}

void xOrdList(void)
{
  List= new T_OrdList(&Compare);
  TestList(List);
  delete List;
}

#include "slltstm.c"

int main(void)
{
  slltstm();
  printf("Exit\n\n");
  return 0;
}