// SLLLIB.H : Single Linked List object library
//
// Title    : SLLLIB
// Version  : 2.1
// Date     : Nov 27,1996
// Author   : J R Ferguson
// Language : Turbo C++ 3.1 for Windows
// Usage    : Header file

//.hlptx skip 1
#ifndef Sll_Lib
#define Sll_Lib

#include "objlib.h"

/* --- Private definitions --- */

typedef struct _Sll_Node {
  void              *Item;
  struct _Sll_Node  *Next;
} T_Sll_Node;

typedef T_Sll_Node  *PT_Sll_Node;

/*.hlptx skip 1*/
/* --- Public definitions --- */

_CLASSDEF(T_Sll_List);
class T_Sll_List : public T_Object
// Single linked list, acting as a First In First Out queue.
{
public:
  PT_Sll_Node     Head,Tail;

  T_Sll_List(void);
  // Create an empty list.
  // Override: sometimes. 
  virtual ~T_Sll_List(void);
  // Discard list after deleting and disposing of all nodes in it by
  // calling DeleteAll().
  // Override: sometimes. 
  virtual void   FreeItem(void *V_Item); 
  // Disposes of the specified item, freeing any memory allocated by it.
  // The default FreeItem does nothing. In most cases you will override
  // this method. When V_Item is an object class pointer of type PT_Item,
  // the code could be:
  //   delete (P_Item)V_Item;
  // FreeItem() is calles by DeleteAll() for each node item that is not
  // NULL, before that node itself is deallocated. It should never be
  // called directly, because that would leave a node with an invalid Item
  // pointer in the list.
  // Override: often. 
  virtual void   DeleteAll(void); 
  // Delete and dispose of all nodes in the list. Before a node is
  // deleted, FreeItem() is called with its Item pointer as a parameter,
  // unless the Item pointer is NULL.
  // The result is an empty list.
  // Override: seldom. 
  virtual int   Empty(void);
  // return 1 if the list is empty, and 0 if it contains at least one
  // element.
  // Override: never. 
  virtual int    Insert(void *V_Item); 
  // Insert V_Item into the list as the last element.
  // The function result is 1 on success, and 0 if there is not enough
  // memory to insert the item.
  virtual void * Retrieve(void);
  // Retrieve a pointer to the first item in the list, and delete the
  // node containing that item from the list, without disposing of the
  // Item.
  // Returns NULL if the list is empty.
  // Override: never. 
  virtual void   ForEach(PT_ProcessProc V_ProcessProc); 
  // Process all items with the specified procedure in the order they were
  // inserted.
  // Override: never.
};

_CLASSDEF(T_Sll_Stack);
class T_Sll_Stack : public T_Sll_List 
// Last In First Out Stack.
{
public:
  virtual int    Insert(void *V_Item);
  // Insert V_Item into the list as the first element.
  // The function result is 1 on success, and 0 if there is not enough
  // memory to insert the item.
};

_CLASSDEF(T_Sll_OrdList);
class T_Sll_OrdList : public T_Sll_List
// Ordered Linked List.
{
public:
  PT_CompareFunc CompareFunc;

  T_Sll_OrdList(PT_CompareFunc V_CompareFunc);
  // Create new (empty) list, setting the compare function on which to
  // base its ordering. 
  virtual int    Insert(void *V_Item);
  // Insert V_Item into the list at a position that keeps the list in a
  // non-descending order, based on CompareFunc. 
  // The function result is 1 on success, and 0 if there is not enough
  // memory to insert the item.
  virtual void   Merge(PT_Sll_OrdList V_OrdList);
  // Merge V_OrdList into the list, deleting (but not disposing of) all
  // items from V_OrdList.
};

//.hlptx skip 1
#endif /* #ifndef Sll_Lib */
