// SLLLIB.CPP : Single Linked List object library
//
// Title    : SLLLIB
// Version  : 2.1
// Date     : Nov 27,1994
// Author   : J R Ferguson
// Language : Turbo C++ v3.1 for Windows
// Usage    : Class library

#include <stddef.h>
#include "slllib.h"


// --- T_Sll_List member functions ---

T_Sll_List::T_Sll_List(void)
: T_Object()
{ Head= NULL; Tail= NULL; }

T_Sll_List::~T_Sll_List(void)
{ DeleteAll(); }

void   T_Sll_List::FreeItem(void *V_Item) {}

void   T_Sll_List::DeleteAll(void)
{ void *Item;
  while (!Empty()) FreeItem(Retrieve());
}

int T_Sll_List::Empty(void)
{ return Head==NULL; }

int    T_Sll_List::Insert(void *V_Item)
{ PT_Sll_Node node;

  node= new T_Sll_Node;
  if (node == NULL) return 0;
  else {
    node->Item= V_Item; node->Next= NULL;
    if (Empty()) Head= node; else (Tail->Next)= node;
    Tail= node;
    return 1;
  }
}

void *T_Sll_List::Retrieve()
{ PT_Sll_Node h; void *item;

  if (Empty()) return NULL;
  else {
    item= Head->Item; if (Head==Tail) Tail= NULL;
    h= Head; Head= Head->Next; delete h;
    return item;
  }
}

void   T_Sll_List::ForEach(PT_ProcessProc V_ProcessProc)
{ PT_Sll_Node node;

  if (V_ProcessProc != NULL) {
    node= Head;
    while (node != NULL) {
      (*V_ProcessProc)(node->Item);
      node= node->Next;
} } }


// --- T_Sll_Stack member functions --- 

int    T_Sll_Stack::Insert(void *V_Item)
{ PT_Sll_Node node;

  node= new T_Sll_Node;
  if (node == NULL) return 0;
  else {
    node->Item= V_Item; node->Next= Head;
    Head= node; if (Tail == NULL) Tail= node;
    return 1;
  }
}


// --- T_Sll_OrdList member functions --- 

T_Sll_OrdList::T_Sll_OrdList(PT_CompareFunc V_CompareFunc)
: T_Sll_List()
{ CompareFunc= V_CompareFunc; }

int   T_Sll_OrdList::Insert(void *V_Item)
{ PT_Sll_Node p, node;

  node= new T_Sll_Node;
  if (node == NULL) return 0;
  else {
    node->Item= V_Item;
    if (Empty()) { Head= node; Tail= node; }
    else {
      Tail->Next= node;
      node->Next= Head;
      p= node;
      while ((*CompareFunc)(p->Next->Item,V_Item) < 0) p= p->Next;
      if      (p==node) Head= node;
      else if (p==Tail) Tail= node;
      else              { node->Next= p->Next; p->Next= node; }
    }
    Tail->Next= NULL;
    return 1;
  }
}

void   T_Sll_OrdList::Merge(PT_Sll_OrdList V_OrdList)
{ while (!V_OrdList->Empty()) Insert(V_OrdList->Retrieve()); }
