/* SETTST.C - Test SETLIB

  Title    : SETTST
  Version  : 1.1
  Date     : Nov 27,1996
  Author   : J R Ferguson
  Language : Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage    : Test program

[ Project file:
settst   (setlib.h,settstm.h)
settstm  (settstm.h)
setlib   (setlib.h)
]
*/

#include <stddef.h>
#include <conio.h>
#include <stdio.h>
#include "setlib.h"
#include "settstm.h"

#define  MAXSTRING 80
#define  wrln()   printf("\n")
#define  wrln2()  printf("\n\n")

char     inpbuf[MAXSTRING];

Set_Elm  val, low, high;
Set_Typ  set1, set2, result;


Set_Elm  rdval(const char *prompt)
{ int n; char *buf;

  do {
    printf("%s : ",prompt);
    buf= gets(inpbuf);
  } while ((sscanf(buf,"%i",&n) != 1) || (n < Set_MIN) || (n > Set_MAX));
  return (Set_Elm)n;
}

void wrbyte(unsigned char byte)
{ int i;

  for (i=0; i<8; i++) {
    putchar(((byte & 0x80) == 0) ? '.' : 'I');
    byte <<= 1;
  }
}


void wrword(unsigned int word)
{
  wrbyte(word / 256); putchar(' ');
  wrbyte(word % 256);
}


void wrset(const char *text, const Set_Ptr set)
{ int word = 0;

  printf("%s :\n",text);
  while (word < Set_SIZE) {
    wrword(set[word++]);
    if ((word % 4) == 0) wrln(); else putchar(' ');
  }
}


void xDisplay(void)
{
  wrln();
  wrset("set1",set1);
  wrset("set2",set2);
}

void xCard(void)
{
  wrln();
  wrset("set1",set1);
  printf("cardinality = %u\n",Set_Card(set1));
}

void xClear(void)
{
  wrln();
  wrset("set1 before",set1);
  Set_Clear(set1);
  wrset("set1 after",set1);
}


void xDeleteVal(void)
{
  wrln();
  wrset("set1 before",set1);
  val=rdval("value");
  Set_DeleteVal(set1,val);
  wrset("set1 after",set1);
}


void xDeleteRng(void)
{
  wrln();
  wrset("set1 before",set1);
  low =rdval("low  value");
  high=rdval("high value");
  Set_DeleteRng(set1,low,high);
  wrset("set1 after",set1);
}


void xInsertVal(void)
{
  wrln();
  wrset("set1 before",set1);
  val=rdval("value");
  Set_InsertVal(set1,val);
  wrset("set1 after",set1);
}


void xInsertRng(void)
{
  wrln();
  wrset("set1 before",set1);
  low =rdval("low  value");
  high=rdval("high value");
  Set_InsertRng(set1,low,high);
  wrset("set1 after",set1);
}


void xIntersection(void)
{
  xDisplay();
  wrset("intersection",Set_Intersection(result,set1,set2));
}

void xInverse(void)
{
  wrln();
  wrset("set1",set1);
  wrset("inverse",Set_Inverse(result,set1));
}

void xUnion(void)
{
  xDisplay();
  wrset("Set_Union",Set_Union(result,set1,set2));
}


void xDifference(void)
{
  xDisplay();
  wrset("Set_Difference",Set_Difference(result,set1,set2));
}


void xIn(void)
{
  wrln();
  wrset("set1",set1);
  val=rdval("value");
  printf("Set_In(set1,val) = %d\n",Set_In(set1,val));
}


void xEmpty(void)
{
  wrln();
  wrset("set1",set1);
  printf("Set_Empty(set1) = %d\n",Set_Empty(set1));
}


void xContains(void)
{
  xDisplay();
  printf("Set_Contains(set2,set1) = %d\n",Set_Contains(set2,set1));
}


void xEq(void)
{
  xDisplay();
  printf("Set_Eq(set1,set2) = %d\n",Set_Eq(set1,set2));
}


void xCpy(void)
{
  wrln();
  wrset("set1 before copy",set1);
  Set_Cpy(set2,set1);
  wrset("set1 after copy",set1);
  wrset("set2 after copy",set2);
}



int main(void)
{
  settstm();
  printf("Exit\n\n");
  return 0;
}
