/* SCKLIB.H  String check functions

   Title   : SCKLIB
   Version : 4.0
   Date    : Nov 27,1996
   Author  : J.R. Ferguson
   Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
   Usage   : Header file
*/

/*.hlptx skip 1*/
#ifndef  Sck_Lib
#define Sck_Lib

/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

int  Stz_IsAlpha(const char *s);
/* Returns 1 if string s is empty or contains only alphabetic
   characters ('A'..'Z','a'..'z').
   Returns 0 if this is not the case.
*/

int  Stz_IsDigit(const char *s);
/* Returns 1 if string s is empty or contains only digits ('0'..'9').
   Returns 0 if this is not the case.
*/

int  Stz_IsAlnum(const char *s);
/* Returns 1 if string s is empty or contains only alfanumeric
   characters ('A'..'Z', 'a'..'z', '0'..'9').
   Returns 0 if this is not the case.
*/

int  Stz_IsAscii(const char *s);
/* Returns 1 if string s is empty or contains only ASCII characters
   (ordinal value 0..127).
   Returns 0 if this is not the case.
*/

int  Stz_IsCntrl(const char *s);
/* Returns 1 if string s is empty or contains only control-characters
   (ordinal value 0..31 or 127).
   Returns 0 if this is not the case.
*/

int  Stz_IsPrint(const char *s);
/* Returns 1 if string s is empty or contains only printable
   characters (ordinal value 32..126).
   Returns 0 if this is not the case.
*/

int  Stz_IsGraph(const char *s);
/* Returns 1 if string s is empty or contains only (visible) graphic
   characters (ordinal value 33..126).
   Returns 0 if this is not the case.
*/

int  Stz_IsLower(const char *s);
/* Returns 1 if string s is empty or contains only lower case letters
   ('a'..'z').
   Returns 0 if this is not the case.
*/

int  Stz_IsUpper(const char *s);
/* Returns 1 if string s is empty or contains only upper case letters
   ('A'..'Z').
   Returns 0 if this is not the case.
*/

int  Stz_IsPunct(const char *s);
/* Returns 1 if string s is empty or contains only puctuation characters
   (printable characters that are not alphanumeric).
   Returns 0 if this is not the case.
*/

int  Stz_IsSpace(const char *s);
/* Returns 1 if string s is empty or contains only 'white space'
   character (space, horizontal tab, vertical tab, carriage return,
   line feed and form feed). Ordinal values 9..12 and 32.
   Returns 0 if this is not the case.
*/

int  Stz_IsBDigit(const char *s);
/* Returns 1 if string s is empty or contains only binary digits
   ('0','1').
   Returns 0 if this is not the case.
*/

int  Stz_IsQDigit(const char *s);
/* Returns 1 if string s is empty or contains only octal digits
   ('0'..'7').
   Returns 0 if this is not the case.
*/

int  Stz_IsXDigit(const char *s);
/* Returns 1 if string s is empty or contains only hexadecimal digits
   ('0'..'9', 'A'..'F', 'a'..'f').
   Returns 0 if this is not the case.
*/

int  Stz_IsPict(const char *p, const char *s);
/* Returns 1 if string matches picture p. This means the following
   conditions must be met:
   1. String p and string s contain the same number of characters.
   2. The characters below have a special meaning in picture p:
        'A' : upper case letter
        'a' : lower case letter
        '9' : decimal digit
        'B' : binary digit
        'H' : hexadecimal digit
        'Q' : octal digit
        'X' : alphanumeric character
        '@' : printable character
      Where one of those characters is found in picture p, the character
      on that position in string s must match this character class.
   3. Where a character other than one of the special characters listed in
      condition 2 is found in pattern p, the character on that position in
      string s must be the same.
   If at least one of these conditions is not met, the function returns 0.
*/

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* #ifndef Sck_Lib */
