/* SCKLIB.C  String check functions

   Title   : SCKLIB
   Version : 4.0
   Date    : Nov 27,1996
   Author  : J.R. Ferguson
   Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
   Usage   : Function library
*/

#include <string.h>
#include "scklib.h"
#include "chrlib.h"

int Stz_IsAlpha(const char *s)
{ while (Chr_IsAlpha(*s)) ++s; return *s==0; }

int Stz_IsDigit(const char *s)
{ while (Chr_IsDigit(*s)) ++s; return *s==0; }

int Stz_IsAlnum(const char *s)
{ while (Chr_IsAlnum(*s)) ++s; return *s==0; }

int Stz_IsAscii(const char *s)
{ while (Chr_IsAscii(*s) && (*s != 0)) ++s; return *s==0; }

int Stz_IsCntrl(const char *s)
{ while (Chr_IsCntrl(*s) && (*s != 0)) ++s; return *s==0; }

int Stz_IsPrint(const char *s)
{ while (Chr_IsPrint(*s)) ++s; return *s==0; }

int Stz_IsGraph(const char *s)
{ while (Chr_IsGraph(*s)) ++s; return *s==0; }

int Stz_IsLower(const char *s)
{ while (Chr_IsLower(*s)) ++s; return *s==0; }

int Stz_IsUpper(const char *s)
{ while (Chr_IsUpper(*s)) ++s; return *s==0; }

int Stz_IsPunct(const char *s)
{ while (Chr_IsPunct(*s)) ++s; return *s==0; }

int Stz_IsSpace(const char *s)
{ while (Chr_IsSpace(*s)) ++s; return *s==0; }

int Stz_IsBDigit(const char *s)
{ while (Chr_IsBDigit(*s)) ++s; return *s==0; }

int Stz_IsQDigit(const char *s)
{ while (Chr_IsQDigit(*s)) ++s; return *s==0; }

int Stz_IsXDigit(const char *s)
{ while (Chr_IsXDigit(*s)) ++s; return *s==0; }

int Stz_IsPict(const char *p, const char *s)
{ register int ok;

  if (strlen(s) != strlen(p)) return 0;
  else {
    ok= 1; --p; --s;
    while (ok && ( *(++s) != 0) ) {
      switch ( *(++p) ) {
        case 'A': ok= Chr_IsUpper(*s);  break;
        case 'a': ok= Chr_IsLower(*s);  break;
        case '9': ok= Chr_IsDigit(*s);  break;
        case 'X': ok= Chr_IsAlnum(*s);  break;
        case '@': ok= Chr_IsPrint(*s);  break;
        case 'B': ok= Chr_IsBDigit(*s); break;
        case 'Q': ok= Chr_IsQDigit(*s); break;
        case 'H': ok= Chr_IsXDigit(*s); break;
        default : ok= *s == *p;     break;
      }
    }
    return ok != 0;
  }
}
