/* RRGTST.C : Test RRGLIB

  Title   : RRGTST
  Version : 4.0
  Date    : Niv 26,1996
  Author  : J R Ferguson
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage   : Test program

[ Project file:
rrgtst   (rrgtstm.h,rrglib.h)
rrgtstm  (rrgtstm.h)
rrglib   (rrglib.h)
]
*/

#include <stdlib.h>
#include <stdio.h>
#include "rrglib.h"
#include "rrgtstm.h"

Rrg_Typ  r1, r2;
float    lb, hb, i;
int      li, hi;
char     inpbuf[80];
char    *inpptr;

#define  wrln()     printf("\n")
#define  wrln2()    printf("\n\n")

int rdint(const char *prompt)
{ int n;

  do {
    printf("%s : ",prompt); inpptr=gets(inpbuf);
  }
  while (sscanf(inpptr,"%d",&n) != 1);
  return n;
}


float rdfloat(const char *prompt)
{ float x;

  do {
    printf("%s : ",prompt); inpptr=gets(inpbuf);
  }
  while (sscanf(inpptr,"%f",&x) != 1);
  return x;
}


void displayrange(Rrg_Typ r)
{
  if (r != NULL) {
    if (r->li) printf("[ "); else printf("< ");
    printf("%g , %g", r->lb, r->hb);
    if (r->hi) printf(" ]"); else printf(" >");
    if (r->nxt != NULL) {
      printf("\n  U  ");
      displayrange(r->nxt);
    }
  }
}

void displayrange1(void)
{
  printf("r1 : "); displayrange(r1); wrln();
}

void displayrange2(void)
{
  printf("r2 : "); displayrange(r2); wrln();
}

void displayranges(void)
{
  displayrange1();
  displayrange2();
}

void readlh(void)
{
 lb=rdfloat("lb (real)");
 li=rdint  ("li (0/1) ");
 hb=rdfloat("hb (real)");
 hi=rdint  ("hi (0/1) ");
}

void readi(void)
{ i= rdfloat("i"); }


void xInside(void)
{
  wrln2();
  displayrange1();
  readi();
  printf("Rrg_Inside=%d\n",Rrg_Inside(&r1,i));
  wrln2();
}

void xInsert(void)
{
  wrln2();
  displayrange1();
  readlh();
  Rrg_Insert(&r1,lb,li,hb,hi);
  displayrange1();
}

void xDelete(void)
{
  wrln2();
  displayrange1();
  readlh();
  Rrg_Delete(&r1,lb,li,hb,hi);
  displayrange1();
}

void xMerge(void)
{
  wrln2();
  displayranges();
  Rrg_Merge(&r1,&r2);
  displayranges();
}

void xRemove(void)
{
  wrln2();
  displayranges();
  Rrg_Remove(&r1,&r2);
  displayranges();
}

void xClear(void)
{
  wrln2();
  displayrange1();
  Rrg_Clear(&r1);
  displayrange1();
}

void xEmpty(void)
{
  wrln2();
  displayrange1();
  printf("Rrg_Empty = %d\n",Rrg_Empty(&r1));
}

void xCopy(void)
{
  wrln2();
  displayranges();
  Rrg_Dispose(&r2);
  Rrg_Copy(&r2,&r1);
  displayranges();
}

void xInvert(void)
{
  wrln2();
  displayrange1();
  Rrg_Invert(&r1);
  displayrange1();
}

void xIntersect(void)
{ Rrg_Typ t;

  wrln2();
  displayranges();
  printf("===> "); displayrange(*Rrg_Intersect(&t,&r1,&r2)); wrln();
  Rrg_Dispose(&t);
}

void xUnite(void)
{ Rrg_Typ t;

  wrln2();
  displayranges();
  printf("===> "); displayrange(*Rrg_Unite(&t,&r1,&r2)); wrln();
  Rrg_Dispose(&t);
}

void xDisplay(void)
{
  wrln2();
  displayranges();
  wrln();
}


void xSwap()
{ Rrg_Typ r;

  wrln2();
  displayranges();
  r= r1; r1= r2; r2= r;
  displayranges();
}


void maininit(void)
{
  Rrg_Create(&r1);
  Rrg_Create(&r2);
}


void mainexit(void)
{
  Rrg_Dispose(&r1);
  Rrg_Dispose(&r2);
}


int main(void)
{
  maininit();
  rrgtstm();
  mainexit();
  return 0;
}