/* RRGLIB.H : Real range handling routines

  Title   : RRGLIB
  Version : 4.0
  Date    : Nov 26,1996
  Author  : J R Ferguson
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage   : Header file

  The internal representation of a (possibly broken) real number range set
  is an ordered list of non-overlapping low-high interval boundaries.
*/

/*.hlptx skip 1*/
#ifndef Rrg_Lib
#define Rrg_Lib

typedef struct Rrg_Struc *Rrg_Typ;   /* global */
typedef struct Rrg_Struc {
  float  lb,hb;    /* low/high boundary */
  int    li,hi;    /* low/high included */
  Rrg_Typ nxt;
} _Rrg_Rec;                          /* local to RRGLIB.C */


/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

Rrg_Typ *Rrg_Create(Rrg_Typ *r);
/* Create an empty range set r, return pointer to r */

void Rrg_Dispose(Rrg_Typ *r);
/* Dispose of the possibly non-empty range set r */

Rrg_Typ *Rrg_Clear(Rrg_Typ *r);
/* Clear existing range set r (making it empty), return pointer to r */

int Rrg_Empty(const Rrg_Typ *r);
/* Test if range set r is empty (contains no values) */

int Rrg_Inside(const Rrg_Typ *r, float i);
/* Return 1 if value i is inside range set r, else 0 */

Rrg_Typ *Rrg_Insert(Rrg_Typ *r,     /* empty or existing range */
                    float    lb,    /* low boundary value      */
                    int      li,    /* low boundary included   */
                    float    hb,    /* high boundary value     */
                    int      hi);   /* high boundary included  */
/* Insert a single range into range set r, return pointer to r */

Rrg_Typ *Rrg_Delete(Rrg_Typ *r,     /* empty or existing range */
                    float    lb,    /* low boundary value      */
                    int      li,    /* low boundary included   */
                    float    hb,    /* high boundary value     */
                    int      hi);   /* high boundary included  */
/* Delete single range from range set r, return pointer to r   */

Rrg_Typ *Rrg_Merge(Rrg_Typ *r1, const Rrg_Typ *r2);
/* Merge range set r2 into range set r1 (result in r1),
   return pointer to r1 */

Rrg_Typ *Rrg_Remove(Rrg_Typ *r1, const Rrg_Typ *r2);
/* Remove range set r2 from range set r1 (result in r1),
   return pointer to r1 */

Rrg_Typ *Rrg_Copy(Rrg_Typ *dst, const Rrg_Typ *src);
/* Copy range set src to dst, return pointer to dst */

Rrg_Typ *Rrg_Invert(Rrg_Typ *r);
/* Invert range set r, return pointer to r */

Rrg_Typ *Rrg_Unite(Rrg_Typ *result, const Rrg_Typ *r1, const Rrg_Typ *r2);
/* Set result to union of range sets r1 and r2, return pointer to result */

Rrg_Typ *Rrg_Intersect(Rrg_Typ *result, 
                 const Rrg_Typ *r1, 
                 const Rrg_Typ *r2);
/* Set result to intersection of range sets r1 and r2,
   return pointer to result */

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* ifndef Rrg_Lib */
