/* RNGTST.C : Test op RNGLIB

  Title   : RNGTST
  Version : 4.0
  Date    : NOV 26,1996
  Author  : J R Ferguson
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage   : Test program

[ Project file:
rngtst    (rngtstm.h,rnglib.h)
rngtstm   (rngtstm.h)
rnglib    (rnglib.h)
tcfd.lib
]
*/

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include "rnglib.h"
#include "rngtstm.h"
#include "conlib.h"
#include "chrlib.h"

Rng_Typ  r1,r2;
int      l,h,i;
char 	 inpbuf[80];
char *   inpptr;

#define  wrln()  printf("\n")
#define  wrln2() printf("\n\n")

int rdint(const char *prompt)
{ int n;

  do {
    printf("%s = ",prompt);
    inpptr= gets(inpbuf);
  }
  while (sscanf(inpptr, "%i",&n) != 1);
  return n;
}

void displayrange(Rng_Typ r)
{
  if (r != NULL) {
    printf("%d..%d",r->l,r->h);
    if (r->nxt != NULL) {
      printf(", ");
      displayrange(r->nxt);
    }
  }
}

void displayrange1(void)
{ printf("r1 : "); displayrange(r1); wrln(); }

void displayrange2(void)
{ printf("r2 : "); displayrange(r2); wrln(); }

void displayranges(void)
{ displayrange1(); displayrange2(); }

void readlh(void)
{ l= rdint("l"); h= rdint("h"); }

void readi(void)
{ i= rdint("i"); }

void xInside(void)
{
  wrln2();
  displayrange1();
  readi();
  printf("Rng_Inside = %d\n\n",Rng_Inside(&r1,i));
}

void xInsert(void)
{
  wrln2();
  displayrange1();
  readlh();
  Rng_Insert(&r1,l,h);
  displayrange1();
}

void xDelete(void)
{
  wrln2();
  displayrange1();
  readlh();
  Rng_Delete(&r1,l,h);
  displayrange1();
}

void xMerge(void)
{
  wrln2();
  displayranges();
  Rng_Merge(&r1,&r2);
  displayranges();
}

void xRemove(void)
{
  wrln2();
  displayranges();
  Rng_Remove(&r1,&r2);
  displayranges();
}

void xDisplay(void)
{
  wrln2();
  displayranges();
  wrln();
}

void xSwap(void)
{ Rng_Typ r;

  wrln2();
  displayranges();
  r= r1; r1= r2; r2= r;
  displayranges();
}

void maininit(void)
{
  Rng_Create(&r1);
  Rng_Create(&r2);
}

void mainexit(void)
{
  Rng_Dispose(&r1);
  Rng_Dispose(&r2);
}

int main(void)
{
  maininit();
  rngtstm();
  mainexit();
  return 0;
}
