/* RNGLIB.H : Integer range handling routines

  Title   : RNGLIB
  Version : 4.0
  Date    : Nov 26,1996
  Author  : J R Ferguson
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage   : Header file

  The internal representation of a (possible broken) integer range is
  an ordered list of non-overlapping low-high interval boundaries.
*/

/*.hlptx skip 1*/
#ifndef Rng_Lib
#define Rng_Lib

typedef struct Rng_Struct *                          Rng_Typ; /* global */
typedef struct Rng_Struct { int l,h; Rng_Typ nxt; } _Rng_Rec; /* local  */


/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

Rng_Typ *Rng_Create(Rng_Typ *r);
/* Create empty range structure r, return pointer to r */

void Rng_Dispose(Rng_Typ *r);
/* Dispose of possibly non-empty range structure r */

int Rng_Inside(const Rng_Typ *r, int i);
/* Return 1 if value i is inside range r, else 0 */

Rng_Typ *Rng_Insert(Rng_Typ *r, int l, int h);
/* Insert range [l,h] into range r, return pointer to r */

Rng_Typ *Rng_Delete(Rng_Typ *r, int l, int h);
/* Delete range [l,h] from range r, return pointer to r */

Rng_Typ *Rng_Merge(Rng_Typ *r1, const Rng_Typ *r2);
/* Merge range r2 into range r1 (result in r1), return pointer to r1 */

Rng_Typ *Rng_Remove(Rng_Typ *r1, const Rng_Typ *r2);
/* Remove range r2 from range r1 (result in r1), return pointer to r1 */

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* ifndef Rng_Lib */
