/* RNGLIB.C : Integer range handling routines

   Title   : RNGLIB
   Version : 4.0
   Date    : Nov 26,1996
   Author  : J R Ferguson
   Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
   Usage   : Function library
*/

#include <stdlib.h>
#include "rnglib.h"


/* --- local definitions --- */


static void order(int *l, int *h)
{ if (*l>*h) { int t;  t=*l; *l=*h; *h=t; } }

static int below(const Rng_Typ r, int i)
{ return (r==NULL) ? 0 : (i < r->l); }

static int above(const Rng_Typ r, int i)
{ return (r==NULL) ? 0 : (i > r->h); }

static int inside(const Rng_Typ r, int i)
{ return (r==NULL) ? 0 : ((i >= r->l) && (i <= r->h)); }

static int connected(const Rng_Typ r1, const Rng_Typ r2)
{ return (r2==NULL) ? 0 : (r1->h >= r2->l - 1); }

static int included(const Rng_Typ r, int l, int h)
{ return (r==NULL) ? 1 : ((l >= r->l) && (h < r->h)); }



/* --- global routines --- */


Rng_Typ *Rng_Create(Rng_Typ *r)
{ *r= NULL; return r; }


void Rng_Dispose(Rng_Typ *r)
{ if (*r != NULL) { Rng_Dispose(&((*r)->nxt)); free(*r); } }


int Rng_Inside(const Rng_Typ *r, int i)
{
  return (*r==NULL)    ? 0 :
         (above(*r,i)) ? Rng_Inside(&((*r)->nxt),i) : inside(*r,i);
}


Rng_Typ *Rng_Insert(Rng_Typ *r, int l, int h)
{ Rng_Typ r0;

  order(&l,&h);
  if (above(*r,l-1)) Rng_Insert(&((*r)->nxt),l,h);
  else if ((*r==NULL) || below(*r,h+1)) {
    if ((r0= (Rng_Typ) malloc(sizeof(_Rng_Rec))) != NULL) {
      r0->l= l; r0->h= h; r0->nxt= *r; *r= r0;
    }
  }
  else if (!included(*r,l,h)) {
    (*r)->l= min(l, (*r)->l);
    (*r)->h= max(h, (*r)->h);
    while (connected(*r, (*r)->nxt)) {
      r0        = (*r)->nxt;
      (*r)->h   = max((*r)->h, r0->h);
      (*r)->nxt = r0->nxt;
      free(r0);
    }
  }
  return r;
}


Rng_Typ *Rng_Delete(Rng_Typ *r, int l, int h)
{ Rng_Typ r0;

  if (*r!=NULL) {
    order(&l,&h);
    if (above(*r,l)) Rng_Delete(&((*r)->nxt), l, h);
    else if (!below(*r,h)) {
      if (l > (*r)->l) {
        if (h < (*r)->h) {
	  if ((r0= (Rng_Typ) malloc(sizeof(_Rng_Rec))) != NULL) {
            r0->l= h+1; r0->h= (*r)->h; r0->nxt= (*r)->nxt;
            (*r)->h= l-1; (*r)->nxt= r0;
          }
        }
        else {
          (*r)->h= l-1;
          Rng_Delete(&((*r)->nxt), l, h);
        }
      }
      else { /* l <= (*r)->l */
        if (h < (*r)->h) (*r)->l= h+1;
        else {
          r0= *r; *r= (*r)->nxt; free(r0);
          Rng_Delete(r,l,h);
        }
      }
    }
  }
  return r;
}


Rng_Typ *Rng_Merge(Rng_Typ *r1, const Rng_Typ *r2)
{
  if (*r2!=NULL) {
    Rng_Insert(r1, (*r2)->l, (*r2)->h);
    Rng_Merge(r1, &((*r2)->nxt));
  }
  return r1;
}


Rng_Typ *Rng_Remove(Rng_Typ *r1, const Rng_Typ *r2)
{
  if (*r2!=NULL) {
    Rng_Delete(r1, (*r2)->l, (*r2)->h);
    Rng_Remove(r1, &((*r2)->nxt));
  }
  return r1;
}
