/* OPTTST.C : Test OPTLIB

  Title    : OPTTST
  Version  : 2.0
  Date     : Nov 23,1996
  Author   : J R Ferguson
  Language : Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage    : Test program

[ Project file:
opttst (optlib.h)
optlib (optlib.h)
tcfw.lib
]
*/

#include <stdio.h>
#include "optlib.h"
#include "rnglib.h"

#define  wr(s)   printf(s)
#define  wrln()  printf("\n")

Opt_LstPtr  opt;

void writerg(Rng_Typ *r)
{
  if (*r != NULL) {
    printf("%d..%d",(*r)->l,(*r)->h);
    if ((*r)->nxt != NULL) {
      printf(", ");
      writerg(&((*r)->nxt));
    }
  }
}

void help(void)
{
wr("usage: OPTTST [/option[..] [..]]\n");
wr("option           type         initial  default  minimum  maximum\n");
wr("---------------  -----------  -------  -------  -------  --------------\n");
wr("S[+/-]           switch       0        1\n");
wr("N[n]             number       80       80       0        255\n");
wr("Mn1[,[n2]]       number list  1,2      ,2       -99,-99  +99,+99\n");
wr("O[n1],n2[,[n3]]  number list  1,2,3    1,,3     0,0,0    9999,9999,9999\n");
wr("R[n1][,[n2]]     range        empty    1,1      1,1      80,80\n");
wr("C[c]             character    '-'      '-'\n");
wr("T[text]          string       \"\"       \"\"\n");
wrln();
}

void maininit(int argc, char *argv[])
{ int i; int ok, allok;

  Opt_Init(&opt);
  Opt_DefSw(&opt,'S');
  Opt_DefNm(&opt,'N',0,   0, 255,80);
  Opt_DefNm(&opt,'M',1, -99, +99, 1);
  Opt_DefNm(&opt,'M',0, -99, +99, 2);
  Opt_DefNm(&opt,'O',0,   0,9999, 1);
  Opt_DefNm(&opt,'O',1,   0,9999, 2);
  Opt_DefNm(&opt,'O',0,   0,9999, 3);
  Opt_DefRg(&opt,'R',0,   1,  80, 1,
                    0,   1,  80, 1);
  Opt_DefCh(&opt,'C','-');
  Opt_DefSt(&opt,'T');
  allok= 1;
  for (i= 1; i<argc; ++i) {
    if (Opt_Parse(&opt,argv[i],&ok)) {
      if (ok)
         printf("option ok     Argument %3d: \"%s\"\n",i,argv[i]);
      else {
         allok= 0;
         printf("option error  Argument %3d: \"%s\"\n",i,argv[i]);
      }
    }
    else printf("no option     Argument %3d: \"%s\"\n",i,argv[i]);
  }
  if (!allok) help();
}


void mainexit(void)
{ Opt_Done(&opt); }


int main(int argc, char *argv[])
{
  printf("OPTTST : Test OPTLIB\n");
  maininit(argc,argv);
  printf("Current options:\n");
  printf("  Switch S: scanned = %d, value = %d\n",
            Opt_Scanned(&opt,'S'),
            Opt_ValSw(&opt,'S'));
  printf("  Number N: scanned = %d, value = %d\n",
            Opt_Scanned(&opt,'N'),
            Opt_ValNm(&opt,'N',1));
  printf("  NumLst M: scanned = %d, value = %d,%d\n",
            Opt_Scanned(&opt,'M'),
            Opt_ValNm(&opt,'M',1),
            Opt_ValNm(&opt,'M',2));
  printf("  NumLst O: scanned = %d, value = %d,%d,%d\n",
            Opt_Scanned(&opt,'O'),
            Opt_ValNm(&opt,'O',1),
            Opt_ValNm(&opt,'O',2),
            Opt_ValNm(&opt,'O',3));
  printf("  Range  R: scanned = %d, value = ",
            Opt_Scanned(&opt,'R'));
    writerg(Opt_ValRg(&opt,'R')); wrln();
  printf("  Char   C: scanned = %d, value = '%c'\n",
            Opt_Scanned(&opt,'C'),
            Opt_ValCh(&opt,'C'));
  printf("  Text   T: scanned = %d, value = \"%s\"\n",
            Opt_Scanned(&opt,'T'),
            Opt_ValSt(&opt,'T'));
  mainexit();
  return 0;
}
