/* OLLTST2.C : Auto-test for OLLLIB

  Title   : OLLTST2
  Version : 1.1
  Date    : Nov 23,1996
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Author  : J R Ferguson
  Usage   : Module linked to OLLTST

  Automatic test : inserts 10 random integers (0..99),
                   then retrieves then in numeric order.
*/

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "olllib.h"
#include "olltst.h"


static Oll_ListTyp list;
static ElmTyp      e;
static int         i;


void olltst2(void)
{
  wrln2();
  printf("Automatic test on OLLLIB\n\n");
  printf("Create list\n");
  if (!Oll_Create(&list, sizeof(ElmTyp), compare))
    printf(">> Failed to create a new list\n");
  else {
    printf("Insert elements\n");
    randomize();
    for (i=0; i < 20 ; ++i) {
      e= random(100);
      printf("%02i ",e);
      if (!Oll_Insert(&list, &e)) {
        printf(">> Insert failed\n");
        break;
      }
    }
    wrln();
    printf("Get first/get next\n");
    if (!Oll_GetFirst(&list, &e))
      printf(">> Getfirst failed\n");
    else {
      printf("%02i ", e);
      while (Oll_GetNext(&list, &e))
        printf("%02i ", e);
    }
    wrln();
    printf("Retrieve elements\n");
    while (!Oll_Empty(&list)) {
      if (!Oll_Retrieve(&list, &e)) {
        printf(">> Retrieve failed\n");
        break;
      }
      printf("%02i ", e);
    }
    wrln();
    printf("Clear list\n");
    Oll_Clear(&list);
  }
  printf("END TEST\n");
}
