/* OLLLIB.H : Ordered linked list routines

  Title    : OLLLIB
  Version  : 1.1
  Date     : Nov 23,1996
  Language : Turbo C 2.0, Turbo C++ 3.1 for Windows
  Author   : J R Ferguson
  Usage    : Header file

Supports fixed length elements only. If elements size is variable, this
library can still be used to maintain a list of pointers to the elements.
*/

/*.hlptx skip 1*/
#ifndef  Oll_Lib
#define  Oll_Lib

#include <mem.h>


typedef struct Oll_EntryStruc *Oll_Ptr;

typedef struct Oll_EntryStruc {
          Oll_Ptr  nxt;
          char     elm[]; /* list element */
        } Oll_Entry;

typedef struct {
          size_t   size; /* size of list elements in bytes */
          int      (*cmp) (const void *, const void *);
                       /* compare function on which list order is based */
          Oll_Ptr  head; /* pointer to dummy header entry */
          Oll_Ptr  curr; /* pointer to current entry */
        } Oll_ListTyp;



/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

int Oll_Create( Oll_ListTyp *list,
                size_t       elmsize,
                int        (*cmp) (const void *, const void *)
              );
/* Creates an empty list for elements of elmsize bytes.
   Initializes the list variable, which can then be used by other
   functions in this library. 
   Returns 1 on success, 0 if failed to properly initialize the list.

   The list ordering will be non-descending (anti-stable), based on the
   compare function cmp which must be defined as
     int cmp(const void *e1, const void *e2)
   where e1 and e2 are pointers to list elements, and the function result
   is negative if *e1 < *e1, zero if *e1 == *e2, and positive if *e1 > *e2.

   The element size and ordering compare criterium for this list remains in
   effect until function Oll_Clear is executed on it. 
   Several lists, with possibly different element sizes and/or compare
   functions associated to them, can be maintained within the same program
   by calling function Oll_Create once for each list.
*/


void Oll_Clear(Oll_ListTyp *list);
/* Destroys an existing list, freeing all allocated memory. */


int Oll_Empty(const Oll_ListTyp *list);
/* Returns 1 if the list is empty or not properly initialized,
   Returns 0 if there is at least 1 element in it */


int Oll_Insert(Oll_ListTyp *list, const void *elm);
/* Inserts the element pointed to by elm into the list, placing it in the
   list chain in such a way the list remains non-descendingly ordered,
   based on the compare function passed to function Oll_Create when the
   list was created.
   Returns 1 on success. Returns 0 in case of failure to allocate memory
   for the element, and also if the list was not properly initialized.
*/


int Oll_Retrieve(Oll_ListTyp *list, void *elm);
/* Copies the first element of the list to the memory location pointed to
   by elm, removing that element from the list. Successive calls to this
   function will retrieve the list elements in a non-descending order,
   based on the compare function passed to function Oll_Create when the
   list was created. 
   Returns 1 on success, 0 if the list was empty or not properly
   initialized when this function was called.
*/


int Oll_GetFirst(Oll_ListTyp *list, void *elm);
/* Positions the current pointer to the first entry of the list and, if
   that entry exitst, copies the element in it to the memory location
   pointed to by elm. 
   Returns 1 on success, 0 if the list was empty or not properly
   initialized when this function was called. 
   Repeated use of Oll_GetNext after this call will get the list elements
   in a non-descending order, based on the compare function passed to
   function Oll_Create when the list was created.
*/


int Oll_GetNext(Oll_ListTyp *list, void *elm);
/* Positions the current pointer to the next entry in the list and, if that
   entry exitst, copies the element in it to the memory location pointed to
   by elm. 
   Successive calls to this function will read the list elements in a
   non-descending order, based on the compare function passed to function
   Oll_Create when the list was created. Returns 1 on success, 0 if there
   are no more elements or the current pointer or the list itself were not
   properly initialized. 
*/

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* ifndef Oll_Lib */
