// OBTTST.CPP - Test ObtLib
//
// Title    : OBTTST
// Version  : 2.2
// Date     : Nov 23,1996
// Author   : J R Ferguson
// Language : Turbo C++ 3.1 for Windows
// Usage    : Test program

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include "objlib.h"
#include "obtlib.h"
#include "obttstm.h"
#include "obttstm1.h"

#define  MAX_ITEM  10

typedef struct {char data;} T_TestItem;
typedef T_TestItem *        PT_TestItem;         
typedef enum                T_Parent {none,left,right};

_CLASSDEF(T_Tree)
class T_Tree : public T_Obt_Tree
{
public:
               T_Tree(PT_CompareFunc V_CompareFunc)
               : T_Obt_Tree(V_CompareFunc) {};
  virtual void FreeItem(void *V_Item);
};

_CLASSDEF(T_SearchTree)
class T_SearchTree : public T_Obt_SearchTree
{
public:
               T_SearchTree(PT_CompareFunc V_CompareFunc)
               : T_Obt_SearchTree(V_CompareFunc) {};
  virtual void FreeItem(void *V_Item);
};

T_TestItem     TestArray[MAX_ITEM];
T_TestItem     TestItem;
PT_Tree        Tree;
PT_SearchTree  SearchTree;

void T_Tree::FreeItem(void *V_Item)
{ if (V_Item != NULL) delete (PT_TestItem)V_Item; }

void T_SearchTree::FreeItem(void *V_Item)
{ if (V_Item != NULL) delete (PT_TestItem)V_Item; }

int Compare(const void *p1, const void *p2)
{ return ((PT_TestItem)p1)->data - ((PT_TestItem)p2)->data; }

void wrln() { printf("\n"); }
void wrl2() { printf("\n\n"); }

void Display(const void *p)
{ printf("%2c",((PT_TestItem)p)->data); }

void WrItem(PT_TestItem p)
{
  if (p==NULL) printf("not found\n");
  else {
    printf("Item ="); Display(p); printf("  OK\n");
  }
}

void RdItem()
{ printf("Item : "); TestItem.data= getche(); wrln(); }

void DisplaySubTree(PT_Obt_Node p, T_Parent parent, int level)
{ int i;

  if (p != NULL) {
    DisplaySubTree(p->Next,right,level+1);
    for (i=0;i<2*level;++i) printf(" ");
    switch (parent) {
      case none : printf("-");  break;
      case left : printf("\\"); break;
      case right: printf("/");  break;
    }
    Display(p->Item); wrln();
    DisplaySubTree(p->Prev,left,level+1);
  }
}

void DisplayTree(PT_Obt_Tree V_Tree)
{ DisplaySubTree(V_Tree->Root,none,0); }

void NewData()
{ int i;

  randomize();
  for (i=0; i<MAX_ITEM; ++i) { TestArray[i].data= 'a' + random(26); }
}

void DisplayData()
{ int i;

  wrl2();
  for (i=0; i<MAX_ITEM; ++i) Display(&TestArray[i]);
  wrln();
}

void TreeGeneral(PT_Obt_Tree V_Tree)
{ int i;

  wrl2(); DisplayTree(V_Tree);
  wrln(); printf("PreOrder :"); V_Tree->PreOrder(Display);
  wrln(); printf("InOrder  :"); V_Tree->InOrder(Display);
  wrln(); printf("PostOrder:"); V_Tree->PostOrder(Display);
  wrln();
}

void WrEmpty(PT_Obt_Tree V_Tree)
{ printf("Empty = %i\n",V_Tree->Empty()); }

void FillTree(PT_Obt_Tree V_Tree)
{ int i; PT_TestItem item;

  V_Tree->DeleteAll();
  for (i=0; i<MAX_ITEM; ++i) {
    item= new T_TestItem; *item= TestArray[i];
    V_Tree->Insert(item);
  }
}

void TestTree(PT_Obt_Tree V_Tree)
{ int i;

  wrl2(); printf("Insert   :");
  for (i=0; i<MAX_ITEM; ++i) Display(&(TestArray[i]));
  FillTree(V_Tree);
  TreeGeneral(V_Tree);
}

void xNewData()
{ NewData(); DisplayData(); }

void xTree()
{
  Tree= new T_Tree(Compare);
  TestTree(Tree);
  delete Tree;
}

void xSTGeneral()
{
  SearchTree= new T_SearchTree(&Compare);
  TestTree(SearchTree);
  delete SearchTree;
}

void xSTNewTree()
{
  delete SearchTree;
  SearchTree= new T_SearchTree(&Compare);
  wrl2(); WrEmpty(SearchTree);
}

void xSTNewData()
{
  NewData();
  delete SearchTree;
  SearchTree= new T_SearchTree(&Compare);
  TestTree(SearchTree);
}

void xSTSearch()
{ PT_TestItem p;

  wrl2(); DisplayTree(SearchTree);
  wrln(); RdItem();
  p= (PT_TestItem)(SearchTree->Search(&TestItem));
  WrItem(p);
}

void xSTInsert()
{ PT_TestItem item;

  wrl2(); DisplayTree(SearchTree);
  wrln(); RdItem(); item= new T_TestItem; *item= TestItem;
  if (SearchTree->Insert(item)) { DisplayTree(SearchTree); WrEmpty(SearchTree); }
   else { printf("already exists\n"); delete item; }
}

void xSTDisplay()
{
  TreeGeneral(SearchTree);
  WrEmpty(SearchTree);
}

void xSTDelete()
{
  wrl2(); DisplayTree(SearchTree);
  wrln(); RdItem();
  if (SearchTree->Delete(&TestItem)) {
    DisplayTree(SearchTree); WrEmpty(SearchTree);
  }
  else printf("not found\n");
}

#include "OBTTSTM1.C"

void xSTOther()
{
  SearchTree= new T_SearchTree(&Compare);
  FillTree(SearchTree);
  obttstm1();
  delete SearchTree;
}

#include "OBTTSTM.C"

int main(void)
{
  NewData();
  obttstm();
  printf("Exit\n\n");
  return 0;
}