// OBTLIB.CPP : Ordered Binary Tree objects
//
// Title    : OBTLIB
// Version  : 2.2
// Date     : Nov 23,1996
// Author   : J R Ferguson
// Language : Turbo C++ 3.1 for Windows
// Usage    : Class member function library

#include <stddef.h>
#include "obtlib.h"

// --- T_Obt_Tree public member functions ---

T_Obt_Tree::T_Obt_Tree(PT_CompareFunc V_CompareFunc)
: T_Object()
{ Root= NULL; CompareFunc= V_CompareFunc; }

T_Obt_Tree::~T_Obt_Tree(void)
{ DeleteAll(); }

void T_Obt_Tree::FreeItem(void *V_Item) {}

void T_Obt_Tree::DeleteAll(void)
{ _Discard(Root); Root= NULL; }

int T_Obt_Tree::Empty(void)
{ return Root == NULL; }

int T_Obt_Tree::Insert(void *V_Item)
{ return _SubTreeInsert(&Root,V_Item); }

void T_Obt_Tree::InOrder(PT_ProcessProc V_ProcessProc)
{ if (V_ProcessProc != NULL) _DoInOrder(Root,V_ProcessProc); }

void T_Obt_Tree::PreOrder(PT_ProcessProc V_ProcessProc)
{ if (V_ProcessProc != NULL) _DoPreOrder(Root,V_ProcessProc); }

void T_Obt_Tree::PostOrder(PT_ProcessProc V_ProcessProc)
{ if (V_ProcessProc != NULL) _DoPostOrder(Root,V_ProcessProc); }

// --- T_Obt_Tree private member functions ---

void T_Obt_Tree::_Discard(PT_Obt_Node V_Node)
{
  if (V_Node != NULL) {
    _Discard(V_Node->Prev); _Discard(V_Node->Next);
    if (V_Node->Item != NULL) FreeItem(V_Node->Item);
    delete V_Node;
  }
}

int  T_Obt_Tree::_SubTreeInsert(PT_Obt_Node *V_Node, void *V_Item)
{
  if (*V_Node == NULL) {
    (*V_Node)= new T_Obt_Node;
    if (*V_Node == NULL) return 0;
    else {
      (*V_Node)->Prev= NULL;
      (*V_Node)->Next= NULL;
      (*V_Node)->Item= V_Item;
      return 1;
    }
  }
  else {
    if ((*CompareFunc)(V_Item,(*V_Node)->Item) < 0)
         return _SubTreeInsert(&((*V_Node)->Prev), V_Item);
    else return _SubTreeInsert(&((*V_Node)->Next), V_Item);
  }
}

void T_Obt_Tree::_DoInOrder(PT_Obt_Node    V_Node,
                            PT_ProcessProc V_ProcessProc)
{
  if (V_Node != NULL) {
    _DoInOrder(V_Node->Prev,V_ProcessProc);
    (*V_ProcessProc)(V_Node->Item);
    _DoInOrder(V_Node->Next,V_ProcessProc);
  }
}

void T_Obt_Tree::_DoPreOrder(PT_Obt_Node    V_Node,
                             PT_ProcessProc V_ProcessProc)
{
  if (V_Node != NULL) {
     (*V_ProcessProc)(V_Node->Item);
     _DoPreOrder(V_Node->Prev,V_ProcessProc);
     _DoPreOrder(V_Node->Next,V_ProcessProc);
  }
}

void T_Obt_Tree::_DoPostOrder(PT_Obt_Node    V_Node, 
                              PT_ProcessProc V_ProcessProc)
{
  if (V_Node != NULL) {
    _DoPostOrder(V_Node->Prev,V_ProcessProc);
    _DoPostOrder(V_Node->Next,V_ProcessProc);
    (*V_ProcessProc)(V_Node->Item);
  }
}


// --- T_Obt_SearchTree public member functions ---

int T_Obt_SearchTree::Insert(void *V_Item)
{ int cmp; PT_Obt_Node node, OldNode;

  if ((cmp= _Locate(V_Item,&OldNode)) == 0) return 0;
  else {
    node= new T_Obt_Node;
    if (node == NULL) return 0;
    else {
      node->Item= V_Item; node->Prev= NULL; node->Next= NULL;
      if (Root == NULL) Root= node;
      else if (cmp < 0) OldNode->Prev= node;
      else              OldNode->Next= node;
      return 1;
    }
  }
}

void *T_Obt_SearchTree::Search(void *V_Item)
{ PT_Obt_Node node;

  return (_Locate(V_Item,&node) == 0) ? node->Item : NULL;
}

int T_Obt_SearchTree::Delete(void *V_Item)
{ PT_Obt_Node DelNode;

  return _Del(&Root, &DelNode, V_Item);
}


// --- T_Obt_SearchTree private member functions ---

int  T_Obt_SearchTree::_Locate(void *V_Item, PT_Obt_Node *V_Node)
{ PT_Obt_Node node; int result;

  result= -1; node= Root; *V_Node= NULL;
  while ((result != 0) && (node != NULL)) {
    *V_Node= node;
    result= CompareFunc(V_Item,node->Item);
    if      (result < 0) node= node->Prev;
    else if (result > 0) node= node->Next;
  }
  return result;
}

void T_Obt_SearchTree::_SubDel(PT_Obt_Node *node, PT_Obt_Node *DelNode)
{
  if ((*node)->Next) _SubDel(&((*node)->Next),DelNode);
  else {
    (*DelNode)->Item= (*node)->Item;
    (*DelNode)= *node; *node= (*node)->Prev;
  }
}

int T_Obt_SearchTree::_Del(PT_Obt_Node *V_Node, 
                           PT_Obt_Node *DelNode, 
                           void        *V_Item)
{ int cmp;

  if (*V_Node == NULL) return 0;
  else {
    cmp= (*CompareFunc)(V_Item,(*V_Node)->Item);
    if      (cmp < 0) return _Del(&(*V_Node)->Prev,DelNode,V_Item);
    else if (cmp > 0) return _Del(&(*V_Node)->Next,DelNode,V_Item);
    else {
      if ((*V_Node)->Item != NULL) FreeItem((*V_Node)->Item);
      *DelNode= *V_Node;
      if      ((*V_Node)->Next == NULL) *V_Node= (*V_Node)->Prev;
      else if ((*V_Node)->Prev == NULL) *V_Node= (*V_Node)->Next;
      else _SubDel(&(*DelNode)->Prev,DelNode);
      delete *DelNode; return 1;
    }
  }
}
