/* NUMTST.C : Test NUMLIB

  Title   : NUMTST
  Version : 4.0
  Date    : Nov 23,1996
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Author  : J.R. Ferguson
  Usage   : Test program

[ Project file:
numtst   (numlib.h,conlib.h)
numlib   (numlib.h)
numtstm  (numtstm.h)
numtstm1 (numtstm1.h)
numtstm2 (numtstm2.h)
numtstm3 (numtstm3.h)
tcfd.lib
]
*/

#include <stdio.h>
#include <conio.h>
#include "numlib.h"
#include "numtstm.h"
#include "numtstm1.h"
#include "numtstm2.h"
#include "numtstm3.h"

long int  i, j;
double    x, y;
char      inpbuf[80];

#define  wrln()   printf("\n")
#define  wrln2()  printf("\n\n")

void rdi(const char *prompt, long int *i)       /* read integer number */
{ int err;

  do {
    printf(prompt);
    scanf("%80s",&inpbuf);
    err= (sscanf(inpbuf,"%li",i) != 1);
    if (err) putch('\x07');
  } while (err);
}


void rdr(const char *prompt, double *x)         /* read real mumber */
{ int err;

  do {
    printf(prompt);
    scanf("%80s",&inpbuf);
    err= (sscanf(inpbuf,"%lG",x) != 1);
    if (err) putch('\x07');
  } while (err);
}


void rdi1(void)  { wrln2(); rdi("i=",&i); }
void rdi2(void)  { wrln2(); rdi("i=",&i); rdi("j=",&j); }
void rdr1(void)  { wrln2(); rdr("x=",&x); }
void rdr2(void)  { wrln2(); rdr("x=",&x); rdr("y=",&y); }
void wri1(void)  { printf("i=%li\n",i); }
void wri2(void)  { printf("i=%li\nj=%li\n",i,j); }
void wrr1(void)  { printf("x=%lG\n",x); }
void wrr2(void)  { printf("x=%lG\ny=%lG\n",x,y); }


void xConst(void)
{
  printf("\n\n\n");
  printf("Num_PI     = %22.20lG\n",Num_PI);
  printf("Num_DBLPI  = %22.20lG\n",Num_DBLPI);
  printf("Num_HALFPI = %22.20lG\n",Num_HALFPI);
  printf("Num_RADIAN = %22.20lG\n",Num_RADIAN);
  printf("\n");
}

void xOdd(void)   { rdi1();printf("Num_Odd(i)=%i\n",Num_Odd(i)); }
void xEven(void)  { rdi1();printf("Num_Even(i)=%i\n",Num_Even(i)); }

void xRMax(void)  { rdr2();printf("Num_RMax=%lG\n",Num_RMax(x,y)); }
void xRMin(void)  { rdr2();printf("Num_RMin=%lG\n",Num_RMin(x,y)); }
void xIMax(void)  { rdi2();printf("Num_IMax=%li\n",Num_IMax(i,j)); }
void xIMin(void)  { rdi2();printf("Num_IMin=%li\n",Num_IMin(i,j)); }

void xRSign(void) { rdr1();printf("Num_RSign(x)=%lG\n",Num_RSign(x)); }
void xISign(void) { rdi1();printf("Num_ISign(i)=%li\n",Num_ISign(i)); }

void xLn(void)    { rdr1();printf("ln(x)=%lG\n",Num_Ln(x)); }
void xLog2(void)  { rdr1();printf("2log(x)=%lG\n",Num_Log2(x)); }
void xLog10(void) { rdr1();printf("10log(x)=%lG\n",Num_Log10(x)); }
void xLogG(void)  { rdr2();printf("y_log x=%lG\n",Num_LogG(y,x)); }

void xRPowerR(void) {rdr2();printf("Num_RPowerR(x,y)=%lG\n",Num_RPowerR(x,y));}
void xIPowerI(void) {rdi2();printf("Num_IPowerI(i,j)=%li\n",Num_IPowerI(i,j));}
void xRPowerI(void) {rdr1();rdi1();printf("Num_RPowerI(x,i)=%lG\n",Num_RPowerI(x,i));}

void xRad(void)     { rdr1();printf("Num_Rad(x)=%lG * Num_PI\n",Num_Rad(x)/Num_PI); }
void xDeg(void)     { rdr1();printf("Num_Deg(x * Num_PI)=%lG\n",Num_Deg(x*Num_PI)); }

void xTan(void)     { rdr1();printf("Num_Tan(x * Num_PI)=%lG\n",Num_Tan(x*Num_PI)); }
void xCot(void)     { rdr1();printf("Num_Cot(x * Num_PI)=%lG\n",Num_Cot(x*Num_PI)); }
void xSec(void)     { rdr1();printf("Num_Sec(x * Num_PI)=%lG\n",Num_Sec(x*Num_PI)); }
void xCosec(void)   { rdr1();printf("Num_Cosec(x * Num_PI)=%lG\n",Num_Cosec(x*Num_PI)); }

void xArcSin(void)  { rdr1();printf("Num_ArcSin(x)=%lG * Num_PI\n",Num_ArcSin(x)/Num_PI); }
void xArcCos(void)  { rdr1();printf("Num_ArcCos(x)=%lG * Num_PI\n",Num_ArcCos(x)/Num_PI); }
void xArcTan(void)  { rdr1();printf("Num_ArcTan(x)=%lG * Num_PI\n",Num_ArcTan(x)/Num_PI); }
void xArcCot(void)  { rdr1();printf("Num_ArcCot(x)=%lG * Num_PI\n",Num_ArcCot(x)/Num_PI); }

void xSinH(void)    { rdr1();printf("Num_SinH(x * Num_PI)=%lG\n",Num_SinH(x*Num_PI)); }
void xCosH(void)    { rdr1();printf("Num_CosH(x * Num_PI)=%lG\n",Num_CosH(x*Num_PI)); }
void xTanH(void)    { rdr1();printf("Num_TanH(x * Num_PI)=%lG\n",Num_TanH(x*Num_PI)); }
void xCotH(void)    { rdr1();printf("Num_CotH(x * Num_PI)=%lG\n",Num_CotH(x*Num_PI)); }


int main(void)
{
  numtstm();
  printf("Exit\n");
  wrln();
  return 0;
}
