/* NUMLIB.C : Numerical routines

  Title   : NUMLIB
  Version : 4.0
  Date    : Nov 23,1996
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Author  : J R Ferguson
  Usage   : Function library
*/

#include  <math.h>
#include  "numlib.h"


double Num_RSign(double x)
{ return (x == 0.0) ? 0.0 : (x > 0.0) ? 1.0 : -1.0; }


long int Num_ISign(long int n)
{ return (n == 0) ? 0 : (n > 0) ? 1 : -1; }


double Num_RPowerI(double x, long int n)
/* by Dennis E. Hamilton v1.08 18-11-'85
   Dr Dobbs Journal of Software Tools, nr 112, FEB 1986 */
{
  long int i;
  double   r;

  if (n==0) return x/x;
  else {
    i= labs(n);
    while (Num_Even(i)) { x *= x; i >>= 1; }
    r= x;
    while (i != 1) {
      do { x *= x; i >>= 1; } while (Num_Even(i));
      r*= x;
    }
    return (n < 0) ? 1.0/r : r;
  }
}


long int Num_IPowerI(long int i, long int n)
{ long int y;

  y= 1;
  while (n > 0) {
    while (Num_Even(n)) { n >>= 1; i *= i; }
    --n; y *= i;
  }
  return y;
}
