/* NIOLIB.H : Numerical I/O library

  Title    : NIOLIB
  Version  : 4.0
  Date     : Nov 23,19964
  Language : Turbo C 2.0, Turbo C++ 3.1 for Windows
  Author   : J.R. Ferguson
  Usage    : Header file

  NIOLIB contains definitions for integer I/O in several numerical bases
  against the standard input/output channels.
*/

/*.hlptx skip 1*/
#ifndef Nio_Lib
#define Nio_Lib

#include <stdlib.h>
#include <conio.h>
#include "cvtlib.h"

/*.hlptx skip 5*/
#ifdef _Windows
 #define cgets    gets
 #define cprintf  printf
#endif

#define      _Nio_MAX    80

/*.hlptx skip 3*/
extern char  _Nio_Buf[];            
extern char *_Nio_Inp;

/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

#define Nio_OWUns(n,g,l)  cprintf(Cvt_ItoABL((n),_Nio_Inp,(g),min((l),_Nio_MAX)))
/* void Nio_OWUns(const int n, const int g, const int l); */
/* Output Word Unsigned.
   Write unsigned integer n with base g in l digits. */

#define Nio_OWUBin(n)  Nio_OWUns((n), 2,16)
/* void Nio_OWUBin(const int n); */
/* Output Word Unsigned Binary.
   Write the binary representation of n in 16 bit
   (0000000000000000..1111111111111111). */

#define Nio_OWUOct(n)  Nio_OWUns((n), 8, 6)
/* void Nio_OWUOct(const int n); */
/* Output Word Unsigned Octal.
   Write the octal representation of n in 6 digits (000000..177777). */

#define Nio_OWUHex(n)  Nio_OWUns((n),16, 4)
/* void Nio_OWUHex(const int n); */
/* Output Word Unsigned Hexadecimal.
   Write the hexadecimal representation of n in 4 digits (0000..FFFF). */

#define Nio_OWUDec(n)  cprintf(Cvt_ItoAB((n),_Nio_Inp,10))
/* void Nio_OWUDec(const int n); */
/* Output Word Unsigned Decimal.
   Write n as an unsigned decimal integer (0..65535). */

#define  Nio_OWSDec(n) cprintf(Cvt_ItoA((n),_Nio_Inp))
/* void Nio_OWSDec(const int n); */
/* Output Word Signed Decimal.
   Write n as a signed decimal integer (-32768..32767). */


#define  Nio_OBUns(n,g,l)  Nio_OWUns((unsigned char)(n),g,l)
/* void Nio_OBUns(const char n, const int g, const int l); */
/* Output Byte Unsigned.
   Write unsigned byte n with base g in l digits. */

#define  Nio_OBUBin(n)  Nio_OBUns(n,2,8)
/* void Nio_OBUBin(n: char); */
/* Output Byte Unsigned Binary.
   Write the binary representation of n in 8 bit (00000000..11111111). */

#define  Nio_OBUOct(n)  Nio_OBUns(n,8,3)
/* void Nio_OBUOct(n: char); */
/* Output Byte Unsigned Octal.
   Write the octal representation of n in 3 digits (000..377). */

#define  Nio_OBUHex(n)  Nio_OBUns(n,16,2)
/* void Nio_OBUHex(const char n); */
/* Output Byte Unsigned Hexadecimal.
   Write the hexadecimal representation of n in 2 digits (00..FF). */

#define  Nio_OBUDec(n)  Nio_OWUDec((unsigned char)(n))
/* void Nio_OBUDec(const char n); */
/* Output Byte Unsigned Decimal.
   Write n as an unsigned decimal byte (0..255). */

#define  Nio_OBSDec(n)  Nio_OWSDec(n)
/* void Nio_OBSDec(const char n); */
/* Output Byte Signed Decimal.
   Write n as a signed decimal byte (-128..127). */


#define  Nio_IWUns(g)   Cvt_AtoIB(cgets(_Nio_Buf),(g))
/* unsigned int Nio_IWUns(const unsigned int g); */
/* Input Word Unsigned.
   Read unsigned integer with base g. */

#define  Nio_IWUBin()   Nio_IWUns(2)
/* unsigned int Nio_IWUBin(void); */
/* Input Word Unsigned Binary.
   Read binary representation of an unsigned integer 
   (0..1111111111111111). */

#define  Nio_IWUOct()   Nio_IWUns(8)
/* unsigned int Nio_IWUOct(void); */
/* Input Word Unsigned Octal.
   Read octal representation of an unsigned integer (0..177777). */

#define  Nio_IWUHex()   Nio_IWUns(16)
/* unsigned int Nio_IWUHex(void); */
/* Input Word Unsigned Hexadecimal.
   Read hexadecimal representation of an unsigned integer (0..FFFF). */

#define  Nio_IWUDec()   Nio_IWUns(10)
/* unsigned int Nio_IWUDec(void); */
/* Input Word Unsigned Decimal.
   Read decimal representation of an unsigned integer (0..65535). */

#define  Nio_IWSDec()   Cvt_AtoI(cgets(_Nio_Buf))
/* unsigned int Nio_IWSDec(void) */
/* Input Word Signed Decimal.
   Read decimal representation of a signed integer (-32768..[+]32767). */


#define  Nio_IBUns(g)  Nio_IWUns(g)
/* char Nio_IBUns(const int g); */
/* Input Byte Unsigned.
   Read unsigned byte with base g. */

#define  Nio_IBUBin()  Nio_IBUns(2)
/* char Nio_IBUBin(void); */
/* Input Byte Unsigned Binary.
   Read binary representation of an unsigned byte (0..11111111). */

#define  Nio_IBUOct()  Nio_IBUns(8)
/* char Nio_IBUOct(void); */
/* Input Byte Unsigned Octal.
   Read octal representation of an unsigned byte (0..377). */

#define  Nio_IBUHex()  Nio_IBUns(16)
/* char Nio_IBUHex(void); */
/* Input Byte Unsigned Hexadecimal.
   Read hexadecimal representation of an unsigned byte (0..FF). */

#define  Nio_IBUDec()  Nio_IBUns(10)
/* char Nio_IBUDec:(void); */
/* Input Byte Unsigned Decimal.
   Read decimal representation of an unsigned byte (0..255). */

#define  Nio_IBSDec()  Nio_IWSDec()
/* char Nio_IBSDec(void); */
/* Input Byte Signed Decimal.
   Read decimal representation of a signed byte (-128..127). */

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* ifndef Nio_Lib */
