/* MATTST.C : Test MatLib and MatIO

  Title   : MATTST
  Version : 4.0
  Date    : Nov 23,1994
  Author  : J.R. Ferguson
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage   : Test program

Use the medium memory model (small model will cause stack overflow)

[ Project file:
mattst  (matlib.h,matio.h)
matlib  (matlib.h)
matio   (matio.h)
tcfd.lib
]
*/

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "conlib.h"
#include "matlib.h"
#include "matio.h"

static Mat_Typ *A, *B, *C, *D;

void AskDimension(Mat_Ind *n, Mat_Ind *m)
{
  Mat_ReadIndex("number of rows    = ",n);
  Mat_ReadIndex("number of columns = ",m);
}


void Read2Mat(Mat_Ptr A, Mat_Ptr B)
{
  printf("First matrix:\n" ); Mat_Read(A);
  printf("Second matrix:\n"); Mat_Read(B);
}


void WriteResult(const Mat_Ptr result)
{
  if (Mat_ErrCod == Mat_ERROK) {
    printf("Result:\n");
    Mat_Write(result);
  }
}


void xZero(void)
{ Mat_Ind n,m;

  printf("Zero\n");
  AskDimension(&n,&m);
  Mat_Dim(A,n,m);
  Mat_Zero(A);
  Mat_Write(A);
}


void xUnify(void)
{ Mat_Ind n,m;

  printf("Unify\n");
  AskDimension(&n,&m);
  Mat_Dim(A,n,m);
  Mat_Unify(A);
  Mat_Write(A);
}


void xAdd(void)
{
  printf("Add\n");
  Read2Mat(A,B);
  Mat_Add(A,B,C);
  WriteResult(C);
}


void xSubtract(void)
{
  printf("Subtract\n");
  Read2Mat(A,B);
  Mat_Subtract(A,B,C);
  WriteResult(C);
}


void xScalarProd(void)
{ Mat_ElmTyp fact;

  printf("ScalarProd\n");
  printf("Matrix:\n");
  Mat_Read(A);
  printf("Factor: ");
  scanf("%lG",&fact);
  Mat_ScalarProd(fact,A,B);
  WriteResult(B);
}


void xMatrixProd(void)
{
  printf("MatrixProd\n");
  Read2Mat(A,B);
  Mat_MatrixProd(A,B,C);
  WriteResult(C);
}


void xTranspose(void)
{
  printf("Transpose\n");
  printf("Matrix:\n");
  Mat_Read(A);
  Mat_Transpose(A,B);
  WriteResult(B);
}


void xPower(void)
{ int exp;

  printf("Power\n");
  printf("Matrix:\n");
  Mat_Read(A);
  printf("Exponent: ");
  scanf("%i",&exp);
  Mat_Power(A,exp,B);
  WriteResult(B);
}


void xSsq(void)
{ Mat_ElmTyp result;

  printf("Sum of squares\n");
  Mat_Read(A);
  Mat_Ssq(A,&result);
  printf("Result : %E\n",result);
}

void xInvert(void)
{ int singular;

  printf("Invert\n");
  printf("Matrix:\n");
  Mat_Read(A);
  Mat_Invert(A,B,&singular);
  if (singular) printf("singular\n");
  else WriteResult(B);
}


void xDet(void)
{ Mat_ElmTyp d;

  printf("Det\n");
  printf("Matrix:\n");
  Mat_Read(A);
  Mat_Det(A,&d);
  printf("Determinant: %E\n", d);
}


void xSolve(void)
{ int n;
  int singular;

  printf("Set of linear equations A  x = b\n\n");
  printf("Coefficient matrix A :\n");
  Mat_Read(A);
  printf("Constants vector b :\n");
  Mat_Read(B);
  Mat_Solve(A,B,C,&singular);
  if (singular)
    printf("no solution\n");
  else {
    printf("Solution vector x:\n");
    Mat_Write(C);
  }
}


void menu(char *choice)
{
  clrscr();
  printf("Test MatLib and MatLib\n");
  printf("max row/column : %u\n", Mat_MAX);
  printf("\n");
  printf("A : Zero\n");
  printf("B : Unify\n");
  printf("C : Add\n");
  printf("D : Difference\n");
  printf("E : ScalarProd\n");
  printf("F : MatrixProd\n");
  printf("G : Transpose\n");
  printf("H : Power\n");
  printf("I : Ssq\n");
  printf("J : Inverse\n");
  printf("K : Determinant\n");
  printf("L : Solve\n");
  printf("X : exit\n");
  printf("\n");
  printf("Your choice: ");
  do *choice= Con_UppKey();
  while (strchr("ABCDEFGHIJKLX\x03",*choice) == NULL);
  if (*choice == '\x03') exit(0);
}

void dotest(void)
{ char choice;

  do {
    menu(&choice);
    clrscr();
    switch (choice) {
      case 'A': xZero();        break;
      case 'B': xUnify();       break;
      case 'C': xAdd();         break;
      case 'D': xSubtract();    break;
      case 'E': xScalarProd();  break;
      case 'F': xMatrixProd();  break;
      case 'G': xTranspose();   break;
      case 'H': xPower();       break;
      case 'I': xSsq();         break;
      case 'J': xInvert();      break;
      case 'K': xDet();         break;
      case 'L': xSolve();       break;
      case 'X': /* nothing */   break;
    }
    if (choice != 'X') {
      printf("Error message : '%s'\n",Mat_ErrMsg[Mat_Error()]);
      Con_WaitCR();
    }
  } while (choice != 'X');
}



int main(void)
{
  A= _Mat_Alloc(); Mat_Dim(A,0,0);
  B= _Mat_Alloc(); Mat_Dim(A,0,0);
  C= _Mat_Alloc(); Mat_Dim(A,0,0);
  D= _Mat_Alloc(); Mat_Dim(A,0,0);
  dotest();
  free(D);
  free(C);
  free(B);
  free(A);
  return 0;
}
