/* MATIO.H : Simple matrix I/O routines

  Title   : MATIO
  Version : 4.0
  Date    : Nov 23,1996
  Author  : J.R. Ferguson
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage   : header file

  Interactive I/O, using standard input and output.
  Primarily meant for test purposes.

  Remarks : Matrix index is internally 0..MATMAX-1, but will be presented
	    as 1..MATMAX
*/

/*.hlptx skip 1*/
#ifndef Mat_IO
#define Mat_IO

#include "matlib.h"

/*.hlptx skip 2*/
Mat_Ptr _Mat_Alloc(void);  /* for internal use */

/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

void Mat_WriteElm(Mat_ElmTyp x);
/* Write matrix element value
*/

void Mat_ReadIndex(const char *prompt, Mat_Ind *index);
/* Writes prompt, then reads index, validating for valid bounds
   1..Mat_MAX. The process is repeated until the input passes the
   validation test.
*/

void Mat_Read(Mat_Ptr A);    /* eenvoudige versie */
/* Uses MatReadIndex to read the dimensions (prompting 'n=' and 'm='),
   then prompts for and reads the matrix elements in a row/column order.
*/


void Mat_Write(const Mat_Ptr A);
/* Writes all matrix elements of A in a row/column order.
*/

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* ifndef Mat_IO */
