/* MATIO.C : Simple matrix I/O routines

  Title   : MATIO
  Version : 4.0
  Date    : Nov 23,1996
  Author  : J.R. Ferguson
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage   : Function library
*/

#include <stdio.h>
#include <math.h>
#include "matio.h"
#include "deflib.h"

#define beep()  putchar(ASCII_BEL)


void Mat_WriteElm(Mat_ElmTyp x)
{
  printf("%+E", fabs(x) < Mat_EPS ? 0.0 : x);
}


void Mat_ReadIndex(const char *prompt, Mat_Ind *index)
{ unsigned int n;
  int          error;

  do {
    printf(prompt);
    error= ( (scanf("%u",&n) != 1) || (n < 1) || (n > Mat_MAX) );
    if (error)
      beep();
  } while (error);
  *index= n;
}


void Mat_Read(Mat_Ptr A)  /* eenvoudige versie */
{ Mat_Ind i, j;
  int     error;

  Mat_ReadIndex("n = ",&(A->nrow));
  Mat_ReadIndex("m = ",&(A->ncol));
  printf("\n");
  for (i= 0; i < A->nrow; ++i) {
    for (j= 0; j < A->ncol; ++j) {
      do {
	printf("A(%u,%u) = ", i+1, j+1);
	error= scanf("%lG", &(A->elm[i][j])) != 1;
        if (error) beep();
      } while (error);
    }
    printf("\n");
  }
}


void Mat_Write(const Mat_Ptr A)
{ Mat_Ind i,j;

  for (i= 0; i < A->nrow; ++i)
    for (j= 0; j < A->ncol; ++j) {
      Mat_WriteElm(A->elm[i][j]);
      printf( (j < A->ncol - 1) ? " " : "\n");
    }
}
