/* DTMTST2.C : DTMTST - Dtm_Convert() auto-test

  Title   : DTMTST2
  Version : 2.0
  Date    : Nov 23,1996
  Author  : J R Ferguson
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage   : include file for DTMTST.C
*/


void increment(Dtm_DateRec *dt)
{ unsigned char maxfeb;   /* 28..29   */
  unsigned char maxmonth; /* 28..31   */
  unsigned int  maxjul;   /* 365..366 */

  if (dt->ymd.year % 4 == 0)
       { maxfeb= 29; maxjul= 366; }
  else { maxfeb= 28; maxjul= 365; }

  ++dt->idf;

  switch (dt->ymd.month) {
    case  2: maxmonth= maxfeb; break;
    case  4:
    case  6:
    case  9:
    case 11: maxmonth= 30; break;
    default: maxmonth= 31;
  }
  if (dt->ymd.day < maxmonth) ++dt->ymd.day;
  else {
    dt->ymd.day= 1;
    if (dt->ymd.month < 12) ++dt->ymd.month;
    else { dt->ymd.month=1; ++dt->ymd.year; }
  }

  if (dt->jul.day < maxjul) ++dt->jul.day;
  else { dt->jul.day= 1; ++dt->jul.year; }

  if (dt->cal.day < 7) ++dt->cal.day;
  else {
    dt->cal.day= 1;
    if ((dt->jul.day < maxjul-2) && (dt->jul.day > 4)) ++dt->cal.week;
    else { dt->cal.week= 1; ++dt->cal.year; }
  }

} /* increment */


void outdate(Dtm_DateRec *dt)
{
  printf("%u %hu %hu %u %hu %hu %u %hu  ",
          dt->ymd.year, dt->ymd.month, dt->ymd.day,
          dt->cal.year, dt->cal.week,  dt->cal.day,
	  dt->jul.year,                dt->jul.day);
}


void checkdate(Dtm_DateRec *dt0)
{
  Dtm_DateRec dt1;

  dt0->rc= Dtm_RCOK;
  memcpy(&dt1, dt0, sizeof(Dtm_DateRec));
  Dtm_Convert(&dt1);
  if (memcmp(&dt1, dt0, sizeof(Dtm_DateRec)) != 0) {
    printf("\n%s ", rcname(dt1.rc));
    printf("dt0="); outdate(dt0);
    printf("dt1="); outdate(&dt1);
  }
}


void monitor(Dtm_DateRec *dt)
{
  if (dt->jul.day == 1) {
    printf("%5u", dt->jul.year);
    if (dt->jul.year % 10 == 0) wrln();
  }
}

void xaCvtInit(Dtm_FnTyp func)
{
  dt.fn= func;
  wrln2();
  printf("Auto-test Dtm_Convert %s\n", fnname(func));
  dt.idf     =694325;
  dt.jul.year=1901;                  dt.jul.day=  1;
  dt.ymd.year=1901; dt.ymd.month= 1; dt.ymd.day=  1;
  dt.cal.year=1901; dt.cal.week = 1; dt.cal.day=  2;
  printf("begin: "); outdate(&dt); printf("\n");
}


void xaCvtExit(void)
{
  printf("\nend: ");
  outdate(&dt);
  printf("\n");
}


void xaCvt(Dtm_FnTyp func)
{
  xaCvtInit(func);
  while (dt.idf < 767008) {
    monitor(&dt);
    checkdate(&dt);
    increment(&dt);
  }
  xaCvtExit();
}


void xaCvtIdf(void) {xaCvt(Dtm_FNIDF);}
void xaCvtJul(void) {xaCvt(Dtm_FNJUL);}
void xaCvtYmd(void) {xaCvt(Dtm_FNYMD);}
void xaCvtCal(void) {xaCvt(Dtm_FNCAL);}
