/* DTMTST.C : Test DtmLib

  Title    : DTMTST
  Version  : 2.0
  Date     : Nov 23,1996
  Author   : J R Ferguson
  Language : Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage    : test program


[ Project file:
dtmtst   (dtmlib.h,dtmtst1.c,dtmtst2.c,dtmtst3.c)
dtmtstm  (dtmtstm.h)
dtmtstm1 (dtmtstm1.h)
dtmtstm2 (dtmtstm2.h)
dtmlib   (dtmlib.h)
tcfd.lib
]
*/

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "conlib.h"
#include "dtmlib.h"
#include "dtmtstm.h"
#include "dtmtstm1.h"
#include "dtmtstm2.h"

Dtm_DateRec  dt0, dt;
long int     days;


char *dayname(unsigned char day)
{
  static const char weekday[8][10] =
   { "?????????\0", "monday   \0", "tuesday  \0", "wednesday\0",
     "donderdag\0", "friday   \0", "saturday \0", "sunday   \0" };

  switch (day) {
    case 1  :
    case 2  :
    case 3  :
    case 4  :
    case 5  :
    case 6  :
    case 7  : return (char *)weekday[day];
    default : return (char *)weekday[0];
  }
}


char *fnname(Dtm_FnTyp fn)
{
  static const char function[6][4] =
    {"Cur\0", "Idf\0", "Jul\0", "Ymd\0", "Cal\0", "???\0"};

  switch (fn) {
    case Dtm_FNCUR :
    case Dtm_FNIDF :
    case Dtm_FNJUL :
    case Dtm_FNYMD :
    case Dtm_FNCAL : return (char *)function[fn];
    default        : return (char *)function[5];
  }
}


char *rcname(Dtm_RcTyp rc)
{
  static const char retcod[5][4] =
    { "Ok \0", "Wrn\0", "Rng\0", "Fun\0", "???\0"};

  switch (rc) {
    case Dtm_RCOK  :
    case Dtm_RCWRN :
    case Dtm_RCRNG :
    case Dtm_RCFUN : return (char *)retcod[rc];
    default        : return (char *)retcod[4];
  }
}


#define  wrln()    putchar('\n')
#define  wrln2()   printf("\n\n")


void rdidf(void)
{
  printf("\nIDF : ");
  scanf("%ld",&dt.idf);
}


void rdjul(void)
{
  printf("\nJUL year day : ");
  scanf("%u %u", &dt.jul.year, &dt.jul.day);
}


void rdymd(void)
{
  printf("\nYMD year month day : ");
  scanf("%u %u %u", &dt.ymd.year, &dt.ymd.month, &dt.ymd.day);
}


void rdcal(void)
{
  printf("\nCAL year week day : ");
  scanf("%u %u %u", &dt.cal.year, &dt.cal.week, &dt.cal.day);
}


void wr1daterec(const Dtm_DateRec *dt)
{
  printf("\nRC  = %s\n",rcname(dt->rc));
  printf("IDF = %ld\n",            dt->idf);
  printf("JUL = %4u %03u\n",       dt->jul.year,dt->jul.day);
  printf("YMD = %4u %02u %02u\n",  dt->ymd.year,dt->ymd.month,dt->ymd.day);
  printf("CAL = %4u %02u %1u %s\n",dt->cal.year,dt->cal.week, dt->cal.day,
				      dayname(dt->cal.day));
}


void wr2daterec(const Dtm_DateRec *dt1, const Dtm_DateRec *dt2)
{
  wr1daterec(dt1);
  wr1daterec(dt2);
  wrln();
}


void rddate(const char *prompt)
{ char  c;
  int   ok;

  printf("\n%s : 1=IDF, 2=JUL, 3=YMD, 4=CAL, 5=CUR     [ ]\b\b",prompt);
  do {
    ok= ((c= getch()) >= '1') && (c <= '5');
    if (ok) {
      putch(c);
      switch(c) {
	case '1': dt.fn= Dtm_FNIDF; rdidf(); break;
	case '2': dt.fn= Dtm_FNJUL; rdjul(); break;
	case '3': dt.fn= Dtm_FNYMD; rdymd(); break;
	case '4': dt.fn= Dtm_FNCAL; rdcal(); break;
	case '5': dt.fn= Dtm_FNCUR; wrln();  break;
      }
    }
    else puts("\x07\b \b");
  } while (!ok);
}


void rddays(void)
{
  printf("Days : ");
  scanf("%ld", &days);
}


#include  "DTMTST1.C"
#include  "DTMTST2.C"
#include  "DTMTST3.C"

int main(void)
{
  dtmtstm();
  wrln2();
  return 0;
}
