/* DTMLIB.H : Date manipulation

   Title   : DTMLIB
   Version : 2.0
   Date    : Nov 23,1996
   Author  : J R Ferguson
   Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
   Usage   : Header file

   Supports dates from Jan 01,1901 through Dec 31,2099.
*/

/*.hlptx skip 1*/
#ifndef Dtm_Lib
#define Dtm_Lib

typedef enum     /* function code :                                      */
    { Dtm_FNCUR, /*   Current date                                       */
      Dtm_FNIDF, /*   Internal Date Format                               */
      Dtm_FNJUL, /*   Julian Date                                        */
      Dtm_FNYMD, /*   Year, Month, Day of month                          */
      Dtm_FNCAL  /*   Office-Calendar Year, Week number, Day of Week     */
    } Dtm_FnTyp;

typedef enum     /* return code :                                        */
    { Dtm_RCOK , /*   ok     : success                     date valid    */
      Dtm_RCWRN, /*   warning: out of scale                date rescaled */
      Dtm_RCRNG, /*   error  : out of range                date invalid  */
      Dtm_RCFUN  /*   error  : unknown function code       date invalid  */
    } Dtm_RcTyp;

typedef long int Dtm_IdfTyp;   /* Internal date format :                 */
                               /* Number of days since a fixed reference */
                               /* date used throughout this library.     */

typedef struct                 /* Julian date :                          */
    { unsigned int     year ;  /*   year                   (1901..2099)  */
      unsigned int     day  ;  /*   day of the year            (1..366)  */
    } Dtm_JulTyp;

typedef struct                 /* Normal calendar date :                 */
    { unsigned int     year ;  /*   year                   (1901..2099)  */
      unsigned char    month;  /*   month                       (1..12)  */
      unsigned char    day  ;  /*   day of the month            (1..31)  */
    } Dtm_YmdTyp;

typedef struct               /* Office calendar date :                   */
    { unsigned int     year ;/*   office calendar year      (1901..2099) */
      unsigned char    week ;/*   week number                    (1..53) */
      unsigned char    day  ;/*   day of the week (1=monday .. 7=sunday  */
    } Dtm_CalTyp;
                   /* Week 1 contains the first thursday of the Ymd-year */

typedef struct Dtm_DateStruc
    { Dtm_FnTyp         fn;     /* in     : functiOn code         */
      Dtm_RcTyp         rc;     /* out    : return code           */
      Dtm_IdfTyp        idf;    /* in/out : internal date format  */
      Dtm_JulTyp        jul;    /* in/out : julian date           */
      Dtm_YmdTyp        ymd;    /* in/out : normal calendar date  */
      Dtm_CalTyp        cal;    /* in/out : office calendar date  */
    } Dtm_DateRec;


/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

int Dtm_Convert(Dtm_DateRec *date);
/* Convert date format, get current date, or check date validity.
Usage:
 1. Get current date
    a. Set date->fn to Dtm_FNCUR.
    b. Execute function Dtm_Convert(date).
    c. Read the current date information you need from date->idf,
       date->jul, date->ymd and/or date->cal.
 2. Check date validity.
    a. Fill date->idf, date->jul, date->ymd or date->cal.
    b. Set date->fn to the corresponding function code.
    c. Execute function Dtm_Convert(date). Check the functon result
       to see if the date is valid.
    d. If the function result is FALSE, optionally check date->rc for
       more information on the type of error.
 3. Convert date format.
    a. through d. : same as 2a. through 2d.
    e. If the conversion was successfull (function result TRUE, date->rc
       == Dtm_RcOk) the fields date->idf, date->jul, date->ymd and 
       date->cal contain the date information in each date format.
       If the conversion results in a warning return code (function 
       result is FALSE, date->rc == Dtm_RcWarning), this means the date 
       was invalid but could be rescaled, and all date fields are now 
       filled with valid date information. Examples: 'March 3' will be 
       rescaled to 'April 2', and 'January 0' will become 'Decenber 31' 
       of the previous year.
*/

int Dtm_Add(Dtm_DateRec *date_beg, /* in : starting date  */
            long int     days,     /* in : number of days */
            Dtm_DateRec *date_end  /* out: ending date    */
           );
/*Add/subtract days to/from starting date, get ending date.
Usage:
 a. Fill date_beg->fn and - unless it is Dtm_FnCur - the corresponding 
    date information. This is the starting date.
 b. Execute the function with days set to the number of days you want
    to add to this starting date, and date_end as an output parameter.
 c. Check the function result. If it is TRUE, date_end contains the 
    ending date in all formats. If it is FALSE, date_beg->rc and 
    date_end->rc can be checked - in that order - to obtain information 
    on the type of error.
 To subtract days from a date, add a negative number of days to date_beg
 You will then get a date_end value that is before date_beg.
*/

int Dtm_Subtract(Dtm_DateRec *date_end, /* in : ending date    */
                 Dtm_DateRec *date_beg, /* in : startinf date  */
                 long int    *days      /* out: number of days */
                );
/* Subtract to dates, get number of days in-between.
 Usage:
 a. Fill the functioncode and - unless it is Dtm_FnCur - the corresponding
    date fields of the input parameters date_end and date_beg.
 b. Execute the function and check the function result.
 c. If the function result is TRUE, output parameter days is set to the
    number of days between date_beg and date_end. The value of days will be
    positive if date_end comes later then date_beg, negative if date_end
    comes sooner, and zero if both dates are the same.
    If the function result is FALSE, date_beg->rc and date_end->rc can be
    checked - in that order - to obtain information on the type of error.
*/

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* ifndef Dtm_Lib */
