/* DMPTST.C : Test DMPLIB

  Title   : DMPTST
  Version : 4.0
  Date    : Nov 23,1996
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Author  : J.R. Ferguson
  Usage   : Test program

[ Project file:
dmptst (dmplib.h)
dmplib (dmplib.h)
tcfd.lib
]
*/

#include <stdio.h>
#include "deflib.h"
#include "conlib.h"
#include "dmplib.h"

int             length;
unsigned char   b;
char            inpbuf[82] = { 80 };
char           *inpptr;
char            storage[32] = {"0123456789ABCDEF0123456789ABCDEF"};

void rdlen(void)
{
  do {
    printf("number of bytes : "); inpptr=cgets(inpbuf); putchar('\n');
  } while (sscanf(inpptr,"%i",&length) != 1);
}

int main(void)
{
  printf("Test DMPLIB\n");
  printf("\nBinOut (stop with CR)\n");
  do { 
    putchar(':'); 
    b=(unsigned char)Con_Key(); 
    Dmp_BinOut(b); putchar('\n'); }
  while (b != ASCII_CR);

  printf("\nDump (stop with 0)\n");
  do {
    rdlen();
    Dmp_Dump((void *)storage,length);
  } while (length);
  return 0;
}
