/* DMPLIB.H : Hex/ASCII dump routines

  Titel   : DMPLIB
  Version : 4.0
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Date    : Nov 18,1996
  Author  : J.R. Ferguson
  Usage   : Header file
*/

/*.hlptx skip 1*/
#ifndef Dmp_Lib
#define Dmp_Lib

#include <stdio.h>

/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

void Dmp_BinOut(unsigned char b);
/* Binary Out: write 8-bit byte binary. */

void Dmp_HxdOut(unsigned char b);
/* Hex Digit Out: write b mod 16 as a hexadecimal digit ('0'..'F').
   Normally the value of b should be in the range 0..15. */

void Dmp_HxbOut(unsigned char b);
/* Hex Byte Out: write byte b in 2 hexadecimal digits ('00'..'FF'). */

void Dmp_HxwOut(unsigned int w);
/* Hex Word Out: write word w in 4 hexadecimal digits ('0000'..'FFFF').
*/

void Dmp_AscOut(unsigned char b);
/* ASCII Out: If the value of b is in the range 32..127 the character 
   with ASCII code b is written. If the value of b is outside of that 
   range, a dot character is written. */

void Dmp_DmpHex(void *p);
/* Dump Hex: write a hex dump of 16 bytes of internal memory,
   starting at the specified segment and offset.
*/

void Dmp_DmpAsc(void *p);
/* Dump ASCII: write an ASCII dump of 16 bytes of internal memory,
   starting at the specified segment and offset.
*/

void Dmp_Dump(void *p, int n);
/* Write a combined hexadecimal and ASCII dump of n bytes of internal
   memory in lines of 16 bytes each, starting at the specified segment
   and offset. No partial lines are written; if needed the value of n
   will be rounded up to the next multiple of 16. */

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* define Dmp_Lib */
