/* DMPLIB.C : Hex/ASCII dump routines

  Titel   : DMPLIB
  Version : 4.0
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Date    : Nov 18,1996
  Author  : J.R. Ferguson
  Usage   : Function library
*/

#include <ctype.h>
#include <dos.h>
#include "dmplib.h"

void Dmp_BinOut(unsigned char b)
{ unsigned char m;
  for (m=128; m>0; m/=2) { putchar(48 + (b & m) / m); }
}

void Dmp_HxdOut(unsigned char b)
{ b%= 16; if (b>9) b+=7; putchar(48+b); }

void Dmp_HxbOut(unsigned char b)
{ Dmp_HxdOut(b / 16); Dmp_HxdOut(b % 16); }

void Dmp_HxwOut(unsigned int w)
{ Dmp_HxbOut(w >> 8); Dmp_HxbOut(w & 0xFF); }

void Dmp_AscOut(unsigned char c)
{ if (isprint(c)) putchar(c); else putchar('.'); }

void Dmp_DmpHex(void *p)
{ int i=0; unsigned char *mem = p;
  while (i<16) { Dmp_HxbOut(mem[i++]); putchar(' '); if (i==8) putchar(' '); }
}

void Dmp_DmpAsc(void *p)
{ int i=0; unsigned char *mem = p;
  while (i<16) { Dmp_AscOut(mem[i++]); if (i==8) putchar(' '); }
}

void Dmp_Dump(void *p, int n)
{ unsigned char far *mem;
  for (mem=p; n>0; mem += 16, n -= 16) {
    Dmp_HxwOut(FP_SEG(mem)); putchar(' ');
    Dmp_HxwOut(FP_OFF(mem)); putchar(' '); putchar(' ');
    Dmp_DmpHex((void *)mem); putchar(' ');
    Dmp_DmpAsc((void *)mem); putchar('\n');
  }
}
