/* DIRTST.C : Test DIRLIB

   Title    : DIRTST
   Version  : 4.0
   Date     : Nov 18,1996
   Language : Turbo C 2.0, Turbo C++ 3.1 for Windows
   Author   : J.R. Ferguson
   Usage    : Test program

[ Project file:
dirtst   (dirlib.h,dirtstm.h)
dirtstm  (dirtstm.h)
dirlib   (dirlib.h)
]
*/

#include <stdio.h>
#include <ctype.h>
#include <conio.h>
#include <string.h>
#include "dirlib.h"
#include "dirtstm.h"

#define  wrln()    printf("\n")
#define  wrfsp()   wrstr("fsp",fsp)
#define  rdfsp()   rdstr("fsp",fsp)


char        fcb[Dir_MAXFCB];
char        fsp[80];
Dir_Ptr     directory;
unsigned    total;
char        inpbuf[80];

char *strfill(char *s, char c, unsigned len)
{ size_t n; char *p;

  for (n=strlen(s),p=s+n; n<len; n++) *p++= c;
  *p= '\0';
  return s;
}

char *rdstr(const char *prompt, char *str)
{
  printf("%s : ",prompt);
  strcpy(str,gets(inpbuf)); wrln();
  return str;
}

void wrstr(const char *title, char *str)
{ printf("%s = \"%s\"\n",title,str); }

unsigned rduns(const char *prompt)
{ unsigned n; int ok;

  do {
    printf("%s : ",prompt);
    ok = sscanf(gets(inpbuf),"%u",&n) >= 1;
    wrln();
  } while (!ok);
  return n;
}


void wruns(const char *text, unsigned n)
{ printf("%s = %u\n",text,n); }


char *rdfcb(void)
{
  fcb[0] = (char)rduns("Drn     ");
  rdstr("Filename",fcb+1); strfill(fcb+1,' ',8);
  rdstr("Ext     ",fcb+9); strfill(fcb+9,' ',3);
  return fcb;
}


void wrfcb(void)
{
  printf("Drn         = %i\n",fcb[0]);
  wrstr ("FilenameExt",fcb+1);
}


void xMakeFcb(void)
{ wrln(); Dir_MakeFcb(rdfsp(),fcb); wrfcb(); }


void xMakeFsp(void)
{ wrln(); Dir_MakeFsp(rdfcb(),fsp); wrfsp(); }


void xScan(void) {
  wrln(); rdfsp();
  Dir_Scan(directory=Dir_Create(),Dir_MakeFcb(fsp,fcb));
  total= 0;
  while (!Dir_Empty(directory)) {
    total++;
    printf(Dir_MakeFsp(Dir_Retrieve(directory,fcb),fsp));
    wrln();
  }
  Dir_Clear(directory);
  printf("total files: %u\n",total);
}


int main(void) { dirtstm(); return 0; }
