/* DIRLIB.H : File Control Block handling

   Title    : DIRLIB
   Version  : 4.0
   Date     : Nov 09,1996
   Language : Turbo C 2.0, Turbo C++ 3.1 for Windows
   Author   : J.R. Ferguson
   Usage    : Header file

  Remarks:
  - This library uses the old-fashioned File Control Block format to
    store directory information. Therefore it does not support DOS
    directory paths.
  - Can only be used in the tiny, small and medium memory models.
*/

/*.hlptx skip 1*/
#ifndef Dir_Lib
#define Dir_Lib

#define Dir_MAXFCB  13   /* "dFilenaamExt\0" */

/* Directory list pointer */
typedef struct Dir_Struct *Dir_Ptr;

/* Directory list entry */
typedef struct Dir_Struct { char fcb[Dir_MAXFCB]; Dir_Ptr nxt; } Dir_Entry;

/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

char   *Dir_MakeFcb(const char *fsp, char fcb[Dir_MAXFCB]);
/*
  Converts file specification fsp to file control block fcb.
  Supports wildcards * and ?, but no subdirectories or paths.

  The fcb format is:
   byte 0   : drive code (0=current drive, 1=A:, 2=B:, etc.)
   byte 1-8 : filename  (8 chars, '?' possible, trailing spaces)
   byte 9-11: extension (3 chars, '?' possible, trailing spaces)
   byte 12  : 0 end-of-string marker
  
  If fsp is not a valid file specification, an empty fcb is returned,
  with drive=0, filename="        ", extension="   "
  This condition can be recognized by the test fcb[1] == ' '.
 

  See also: <Dir_MakeFsp>
*/

char   *Dir_MakeFsp(const char fcb[Dir_MAXFCB], char *fsp);
/*
  Converts file control block fcb to file specification fsp.
  The fsp is returned in a free format string, i.e. the file name and
  extension do not have a fixed length and the drive letter and the 
  extension may be omitted.

  The fcb format is:
   byte 0   : drive code (0=current drive, 1=A:, 2=B:, etc.)
   byte 1-8 : filename  (8 chars, '?' allowed, trailing spaces)
   byte 9-11: extension (3 chars, '?' allowed, trailing spaces)
   byte 12  : 0 end-of-string marker
  
  See also: <Dir_MakeFcb>
*/

Dir_Ptr Dir_Create(void);
/* Creates a new, empty directory list dir.

   See also: <Dir_Scan>, <Dir_Clear>
*/

void    Dir_Clear(Dir_Ptr dir);
/* Removes the directory list dir, after removing any fcb entries it
   may contain.

   See also: <Dir_Create>, <Dir_Scan>
*/

int     Dir_Empty(const Dir_Ptr dir);
/* Tests if directory list dir is empty. */

Dir_Ptr Dir_Insert(Dir_Ptr dir, const char *fcb);
/* Inserts file control block fcb into the alphabetically ordered
   directory list dir, if it is no duplicate. */

char   *Dir_Retrieve(Dir_Ptr dir, char *fcb);
/* Retrieves the first control block from directory list dir and
   returns it in the parameter fcb. */

Dir_Ptr Dir_Scan(Dir_Ptr dir, const char *fcbmask);
/*
  Reads the disk directory and inserts the fcb's matching the given
  fcb mask into directory list, maintaining an alphabetical ordering.
  The mask may contain wildcard characters * and ? in the fnm and ext 
  fields. The drn field must be filled with 0 for the current drive,
  1 for A:, 2 for B:, etcetera. Only the current directory of the
  drive specified in the drn field of the fcb mask is scanned.

  The directory list must have been created using procedure Dir_Create
  before procedure DirScan is executed. Procedure Dir_Scan may be executed
  several times using different fcb masks. Matching directory entries are 
  merged maintaining an alphabetic ordering without duplicates.

  See also: <Dir_Create>, <Dir_Clear>
*/


/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* ifndef Dir_Lib */
