/* DIRLIB.C : File Control Block handling

   Title    : DIRLIB
   Version  : 4.0
   Date     : Nov 09,1996
   Language : Turbo C 2.0, Turbo C++ 3.1 for Windows
   Author   : J.R. Ferguson
   Usage    : Function library
*/

#include <dos.h>
#include <dir.h>
#include <mem.h>
#include <ctype.h>
#include <alloc.h>
#include "dirlib.h"


char *Dir_MakeFcb(const char *fsp, char fcb[Dir_MAXFCB])
{ union  REGS  cpuregs;
  struct SREGS segregs;
  char   tmp[44];

  cpuregs.x.ax  = 0x2900; /* make fcb */
  segregs.ds    = _DS;    cpuregs.x.si = (unsigned int) fsp;
  segregs.es    = _DS;    cpuregs.x.di = (unsigned int) tmp;
  intdosx(&cpuregs,&cpuregs,&segregs) ;
  if (cpuregs.h.al == 0xff ) {
    fcb[0]= fcb[Dir_MAXFCB-1]= '\0';
    setmem(fcb+1,Dir_MAXFCB-2,' ');
  }
  else memmove(fcb,tmp,Dir_MAXFCB);
  return fcb;
}


char *Dir_MakeFsp(const char fcb[Dir_MAXFCB], char *fsp)
{ int i, n;
  char *p = fsp;

  if (fcb[0] != '\0') {*p++ = fcb[0] + 64; *p++ = ':'; }
  for (i=1,n=8; (n>0) && (fcb[i] != ' '); ++i,--n) *p++ = fcb[i];
  if (fcb[9] != ' ') {
    *p++ = '.';
    for (i=9,n=3; (n>0) && (fcb[i] != ' '); ++i,--n) *p++ = fcb[i];
  }
  *p = '\0';
  return fsp;
}


Dir_Ptr Dir_Create()
{ Dir_Ptr dir;

  if ((dir= malloc(sizeof(Dir_Entry))) != NULL)
    dir->nxt = dir;
  return dir;
}


void Dir_Clear(Dir_Ptr dir)
{ if (dir != NULL) free(dir); }


int Dir_Empty (const Dir_Ptr dir)
{ return (dir == NULL) ? 1 : (dir->nxt==dir); }


Dir_Ptr Dir_Insert (Dir_Ptr dir, const char *fcb)
{ Dir_Ptr p0,p1;

  if (dir != NULL) {
    memcpy(dir->fcb,fcb,Dir_MAXFCB); p0=dir;
    while (memcmp(p0->nxt->fcb,fcb,Dir_MAXFCB) < 0) p0=p0->nxt;
    if ((memcmp(p0->nxt->fcb,fcb,Dir_MAXFCB) != 0) || (p0->nxt == dir)) {
      if ((p1= malloc(sizeof(Dir_Entry))) != NULL) {
        memcpy(p1->fcb,fcb,Dir_MAXFCB); p1->nxt=p0->nxt; p0->nxt=p1;
  } } }
  return dir;
}

char *Dir_Retrieve (Dir_Ptr dir, char *fcb)
{  Dir_Ptr p;

  if (dir == NULL) *fcb= '\0';
  else {
    p= dir->nxt; memcpy(fcb,p->fcb,Dir_MAXFCB); dir->nxt= p->nxt;
    if (p->nxt != p) free(p);
  }
  return fcb;
}


Dir_Ptr Dir_Scan(Dir_Ptr dir, const char *fcbmask)
{ struct ffblk buffer;
  char far *dta;
  char fspmask[15], fcbfound[Dir_MAXFCB];

  dta= getdta();
  if (findfirst(Dir_MakeFsp(fcbmask,fspmask),&buffer,0) == 0) {
    while ( (Dir_Insert(dir,Dir_MakeFcb(buffer.ff_name,fcbfound)) != NULL)
         && (findnext(&buffer) == 0)
          ) {};
  }
  setdta(dta);
  return dir;
}
