/* CVTTST.C -- Test CVTLIB

  Title   : CVTTST
  Version : 5.0
  Date    : Nov 23,1996
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Author  : J.R. Ferguson
  Usage   : Test program

[ Project file:
cvttst  (cvtlib.h,cvttstm.h)
cvttstm (cvttstm.h)
cvtlib  (cvtlib.h)
]
*/

#include <conio.h>
#include <stdio.h>
#include <string.h>
#include "cvtlib.h"
#include "cvttstm.h"

#define  wrln()      printf("\n")
#define  wrln2()     printf("\n\n")
#define  rdint()     n=askint ("integer  : ")
#define  rdlint()    m=asklint("long int : ")
#define  rdbase()    g=askint ("base     : ")
#define  rdlen()     l=askint ("length   : ")
#define  wrstr()     printf("\"%s\"\n",s)
#define  between(low,val,high)  (((val)>=(low)) && ((val)<=(high)))

char hexdigit[16] = "0123456789ABCDEF";

char     s[81];
int      n,g,l;
long int m;

char  invbuf[83] = { 80, 0 };
char *inv;

void puthexbyt(unsigned char b)
{
  putch(hexdigit[b >> 4]);
  putch(hexdigit[b & 0x0F]);
}

void puthexwrd(unsigned int w)
{
  puthexbyt(w >> 8);
  puthexbyt(w & 0xFF);
  putch(' ');
}

void puthexlwrd(long lw)
{
  puthexwrd(lw >> 16);
  puthexwrd(lw & 0xFFFF);
}

void rdstr()
{ printf("string   : "); strcpy(s,gets(invbuf)); }

int askint(const char *prompt)
{ int val;

  do { printf(prompt); inv= gets(invbuf);
  } while (sscanf(inv,"%i",&val) < 1);
  return val;
}

long asklint(const char *prompt)
{ long val;

  do { printf(prompt); inv= gets(invbuf);
  } while (sscanf(inv,"%li",&val) < 1);
  return val;
}

void wrint()
{
  printf("n = "); puthexwrd((unsigned int)n);
  printf("h,  %i d\n",n);
}

void wrlint()
{
  printf("n = "); puthexlwrd(m);
  printf("h,  %li d\n",m);
}

void TstAtoI()
{ wrln2(); rdstr(); n= Cvt_AtoI(s); wrint(); }

void TstAtoIB()
{ wrln2(); rdstr(); rdbase(); n= Cvt_AtoIB(s,g); wrint(); }

void TstItoA()
{ wrln2(); rdint(); Cvt_ItoA(n,s); wrstr(); }

void TstItoAB()
{ wrln2(); rdint(); rdbase(); Cvt_ItoAB(n,s,g); wrstr(); }

void TstItoABL()
{ wrln2(); rdint(); rdbase(); rdlen(); Cvt_ItoABL(n,s,g,l); wrstr(); }

void TstItoABLS()
{ wrln2(); rdint(); rdbase(); rdlen(); Cvt_ItoABLS(n,s,g,l); wrstr(); }

void TstAtoL()
{ wrln2(); rdstr(); m= Cvt_AtoL(s); wrlint(); }

void TstAtoLB()
{ wrln2(); rdstr(); rdbase(); m= Cvt_AtoLB(s,g); wrlint(); }

void TstLtoA()
{ wrln2(); rdlint(); Cvt_LtoA(m,s); wrstr(); }

void TstLtoAB()
{ wrln2(); rdlint(); rdbase(); Cvt_LtoAB(m,s,g); wrstr(); }

void TstLtoABL()
{ wrln2(); rdlint(); rdbase(); rdlen(); Cvt_LtoABL(m,s,g,l); wrstr(); }

void TstLtoABLS()
{ wrln2(); rdlint(); rdbase(); rdlen(); Cvt_LtoABLS(m,s,g,l); wrstr(); }

void main()
{
  cvttstm();
  clrscr();
}
