/* CVTLIB.H : string <-> integer conversion routines

   Title   : CVTLIB
   Version : 5.0
   Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
   Date    : Nov 18,1996
   Author  : J.R. Ferguson
   Usage   : Header file
*/

/*.hlptx skip 1*/
#ifndef Cvt_Lib
#define Cvt_Lib

#include <stdlib.h>

/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

#define Cvt_AtoI(s) atoi(s)
/* int Cvt_AtoI(const char *s); */
/* Read signed decimal integer from string s */

#define Cvt_AtoIB(s,g)  (unsigned int)(Cvt_AtoLB((s),(g)) & 0xFFFF)
/* unsigned Cvt_AtoIB(const char *s, unsigned g); */
/* Read unsigned integer with base g (1<g<37) from string s */

#define Cvt_AtoL(s) atol(s)
/* long Cvt_AtoL(const char *s); */
/* ead signed decimal longint from string s */

unsigned long Cvt_AtoLB(const char *s, unsigned g);
/* Read unsigned longint with base g (1<g<37) from string s */

#define Cvt_ItoA(n,s) itoa((n),(s),10)
/* char *Cvt_ItoA(int n; char *s); */
/* Convert signed decimal integer n to string s */

char *Cvt_ItoAB(unsigned n, char *s, unsigned g);
/* Convert unsigned integer n with base g (1<g<37) to string s */

char *Cvt_ItoABL(unsigned n, char *s, unsigned g, unsigned l);
/* Like Cvt_ItoAB, with fixed field length l, using leading zeroes */

char *Cvt_ItoABLS(unsigned n, char *s, unsigned g, unsigned l);
/* Like Cvt_ItoAB, with fixed field length l, using leading spaces */

#define Cvt_LtoA(n,s) ltoa((n),(s),10)
/* char *Cvt_LtoA(long n; char *s); */
/* Convert signed decimal longint n to string s */

#define Cvt_LtoAB(n,s,g) ultoa((n),(s),((int) g))
/* char *Cvt_LtoAB(unsigned long n, char *s, unsigned g);
/* Convert unsigned longint n with base g (1<g<37) to string s */

char *Cvt_LtoABL(unsigned long n, char *s, unsigned g, unsigned l);
/* Like Cvt_LtoAB, with fixed field length l, using leading zeroes */

char *Cvt_LtoABLS(unsigned long n, char *s, unsigned g, unsigned l);
/* Like Cvt_LtoAB, with fixed field length l, using leading spaces */

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* ifndef Cvt_Lib */
