/* CVTLIB.C : string <-> integer conversion routines

   Title   : CVTLIB
   Version : 5.0
   Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
   Date    : Nov 18,1996
   Author  : J.R. Ferguson
   Usage   : Function library
*/

#include <ctype.h>
#include <string.h>
#include "cvtlib.h"


/* --- Local routines --- */

static int _DigVal(char c, unsigned g)
/* Return digit value of character c with base g, or -1 if in error */
{ int d;

  if (isxdigit(c)) {
    if (c>'9') d=toupper(c)-55; else d=toupper(c)-48;
    return (d<g) ? d : -1;
  }
  else return -1;
}


static void _UDiv(unsigned t, unsigned n, unsigned *q, unsigned *r)
{
  *q= t / n;
  *r= t % n;
}

static void _ULDiv(unsigned long t , unsigned n,
                   unsigned long *q, unsigned long *r)
{
  *q= t / n;
  *r= t % n;
}


/* --- Library routines --- */


unsigned long Cvt_AtoLB(const char *s, unsigned g)
{ char c;
  int  d;
  unsigned long n;

  n= 0;
  if (g>1 && g<37) {
    while (isspace(c= *s++)) {}
    while ((d=_DigVal(c,g)) >= 0) {
      n= g*n + d;
      c= *s++;
    }
  }
  return n;
}

char *Cvt_ItoAB(unsigned n, char *s, unsigned g)
{ unsigned r; char *p=s;

  if (g>1 && g<37) {
    do {
      _UDiv(n,g,&n,&r);
      *p++ = (r>9 ? r+55 : r+48);
    } while (n);
  }
  *p='\0';
  return strrev(s);
}

char *Cvt_ItoABL(unsigned n, char *s, unsigned g, unsigned l)
{ unsigned r; char *p=s;

  if (g>1 && g<37) {
    while (l-- > 0) {
      _UDiv(n,g,&n,&r);
      *p++ = (r>9 ? r+55 : r+48);
    }
  }
  *p='\0';
  return strrev(s);
}

char *Cvt_ItoABLS(unsigned n, char *s, unsigned g, unsigned l)
{ char *p;

  p= Cvt_ItoABL(n,s,g,l);
  while (*p == '0') *p++ = ' ';
  return s;
}

char *Cvt_LtoABL(unsigned long n, char *s, unsigned g, unsigned l)
{ unsigned long r; char *p=s;

  if (g>1 && g<37) {
    while (l-- > 0) {
      _ULDiv(n,g,&n,&r);
      *p++ = (r>9 ? r+55 : r+48);
    }
  }
  *p='\0';
  return strrev(s);
}

char *Cvt_LtoABLS(unsigned long n, char *s, unsigned g, unsigned l)
{ char *p;

  p= Cvt_LtoABL(n,s,g,l);
  while (*p == '0') { *p= ' '; p++; }
  return s;
}
