/* CONLIB.H : CRT Console constants and routines

  Title   : CONLIB
  Version : 4.1
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Date    : Jan 29,1997
  Author  : J.R. Ferguson
  Usage   : Header file
*/

/*.hlptx skip 1*/
#ifndef Con_Lib
#define Con_Lib

#include <conio.h>
#include <ctype.h>

#ifdef _Windows
  #include <stdio.h>
  #define nl()    printf("\n")
  #define cgets   gets
  #define cprintf printf
  #define cscanf  scanf
#else
  #define nl()    cprintf("\r\n")
#endif

#define KEY_CTRAT     \x00
#define KEY_CTRA      \x01
#define KEY_CTRB      \x02
#define KEY_CTRC      \x03
#define KEY_CTRD      \x04
#define KEY_CTRE      \x05
#define KEY_CTRF      \x06
#define KEY_CTRG      \x07
#define KEY_BS        \x08
#define KEY_CTRH      \x08
#define KEY_TAB       \x09
#define KEY_CTRI      \x09
#define KEY_CTRJ      \x0A
#define KEY_CTRK      \x0B
#define KEY_CTRL      \x0C
#define KEY_CR        \x0D
#define KEY_CTRM      \x0D
#define KEY_CTRN      \x0E
#define KEY_CTRO      \x0F
#define KEY_CTRP      \x10
#define KEY_CTRQ      \x11
#define KEY_CTRR      \x12
#define KEY_CTRS      \x13
#define KEY_CTRT      \x14
#define KEY_CTRU      \x15
#define KEY_CTRV      \x16
#define KEY_CTRW      \x17
#define KEY_CTRX      \x18
#define KEY_CTRY      \x19
#define KEY_CTRZ      \x1A
#define KEY_ESC       \x1B
#define KEY_CTRLBRACK \x1B
#define KEY_CTRBSLASH \x1C
#define KEY_CTRRBRACK \x1D
#define KEY_CTRCARET  \x1E
#define KEY_CTRUSCORE \x1F
#define KEY_CTRBS     \x7F
#define KEY_INS       \x80
#define KEY_END       \x81
#define KEY_DOWN      \x82
#define KEY_PGDN      \x83
#define KEY_LEFT      \x84
#define KEY_CENTER    \x85
#define KEY_RIGHT     \x86
#define KEY_HOME      \x87
#define KEY_UP        \x88
#define KEY_PGUP      \x89
#define KEY_BACKTAB   \x8A
#define KEY_CTRPRTSCR \x8B
#define KEY_CTRLEFT   \x8C
#define KEY_CTRCENTER \x8D
#define KEY_CTRRIGHT  \x8E
#define KEY_CTREND    \x8F
#define KEY_CTRINS    \x90
#define KEY_CTRF01    \x91
#define KEY_CTRF02    \x92
#define KEY_CTRF03    \x93
#define KEY_CTRF04    \x94
#define KEY_CTRF05    \x95
#define KEY_CTRF06    \x96
#define KEY_CTRF07    \x97
#define KEY_CTRF08    \x98
#define KEY_CTRF09    \x99
#define KEY_CTRF10    \x9A
#define KEY_CTRF11    \x9B
#define KEY_CTRF12    \x9C
#define KEY_CTRPGUP   \x9D
#define KEY_CTRDOWN   \x9E
#define KEY_CTRUP     \x9F
#define KEY_CTRDEL    \xA0
#define KEY_SHFF01    \xA1
#define KEY_SHFF02    \xA2
#define KEY_SHFF03    \xA3
#define KEY_SHFF04    \xA4
#define KEY_SHFF05    \xA5
#define KEY_SHFF06    \xA6
#define KEY_SHFF07    \xA7
#define KEY_SHFF08    \xA8
#define KEY_SHFF09    \xA9
#define KEY_SHFF10    \xAA
#define KEY_SHFF11    \xAB
#define KEY_SHFF12    \xAC
#define KEY_ALTMINUS  \xAD
#define KEY_CTRPGDN   \xAE
#define KEY_CTRHOME   \xAF
#define KEY_ALT0      \xB0
#define KEY_ALT1      \xB1
#define KEY_ALT2      \xB2
#define KEY_ALT3      \xB3
#define KEY_ALT4      \xB4
#define KEY_ALT5      \xB5
#define KEY_ALT6      \xB6
#define KEY_ALT7      \xB7
#define KEY_ALT8      \xB8
#define KEY_ALT9      \xB9
#define KEY_ALTEQUAL  \xBD
#define KEY_ALTCENTER \xBE
#define KEY_ALTRIGHT  \xBF
#define KEY_ALTA      \xC1
#define KEY_ALTB      \xC2
#define KEY_ALTC      \xC3
#define KEY_ALTD      \xC4
#define KEY_ALTE      \xC5
#define KEY_ALTF      \xC6
#define KEY_ALTG      \xC7
#define KEY_ALTH      \xC8
#define KEY_ALTI      \xC9
#define KEY_ALTJ      \xCA
#define KEY_ALTK      \xCB
#define KEY_ALTL      \xCC
#define KEY_ALTM      \xCD
#define KEY_ALTN      \xCE
#define KEY_ALTO      \xCF
#define KEY_ALTP      \xD0
#define KEY_ALTQ      \xD1
#define KEY_ALTR      \xD2
#define KEY_ALTS      \xD3
#define KEY_ALTT      \xD4
#define KEY_ALTU      \xD5
#define KEY_ALTV      \xD6
#define KEY_ALTW      \xD7
#define KEY_ALTX      \xD8
#define KEY_ALTY      \xD9
#define KEY_ALTZ      \xDA
#define KEY_ALTINS    \xDB
#define KEY_ALTEND    \xDC
#define KEY_ALTDOWN   \xDD
#define KEY_ALTPGDN   \xDE
#define KEY_ALTLEFT   \xDF
#define KEY_BREAK     \xE0
#define KEY_ALTF01    \xE1
#define KEY_ALTF02    \xE2
#define KEY_ALTF03    \xE3
#define KEY_ALTF04    \xE4
#define KEY_ALTF05    \xE5
#define KEY_ALTF06    \xE6
#define KEY_ALTF07    \xE7
#define KEY_ALTF08    \xE8
#define KEY_ALTF09    \xE9
#define KEY_ALTF10    \xEA
#define KEY_ALTF11    \xEB
#define KEY_ALTF12    \xEC
#define KEY_ALTHOME   \xED
#define KEY_ALTUP     \xEE
#define KEY_ALTPGUP   \xEF
#define KEY_ALTDEL    \xF0
#define KEY_F01       \xF1
#define KEY_F02       \xF2
#define KEY_F03       \xF3
#define KEY_F04       \xF4
#define KEY_F05       \xF5
#define KEY_F06       \xF6
#define KEY_F07       \xF7
#define KEY_F08       \xF8
#define KEY_F09       \xF9
#define KEY_F10       \xFA
#define KEY_F11       \xFB
#define KEY_F12       \xFC
#define KEY_DEL       \xFF

/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

int Con_TstEnhKbd(void);
/* Test if the BIOS of the current system supports the enhanced keyboard
   with, amongst others, function keys F11 and F12. 
   Return 1 if true, 0 if false.

   In a Windows environment, this function always returns 0, since extended
   keys are not supported by this library for MS-Windows programs. 
*/

#define Con_SetCur(row,col) gotoxy(col,row)
/* void Con_SetCur(int row, int col);
   Place the cursor at the given row and column. The upper-left corner of
   the screen has row=1 and col=1. 
*/

char Con_Key(void);
/* Wait until a key is pressed on the keyboard and return the corresponding
   character value without echoing it on the screen.
   In DOS programs, using a PC-compatible keyboard, special keys that 
   produce a 0-character plus some non-zero keycode are translated into 
   a single character with a unique ordinal value.
   In MS-Window programs extended keys are not supported.

   See also: <Con_UppKey>
*/

#define Con_UppKey() (char)toupper(Con_Key())
/* char Con_UppKey(void);
   Like Con_Key(), with upper case translation.

   See also: <Con_Key>
*/


int Con_YesNo(const char *prompt);
/* Displays the given prompt, followed buy the text '? (Y/N) : ', waits
   until one of the keys 'Y', 'y', 'N' or 'n' is pressed, and echoes 'Y'
   or 'N' followed by a carriage return and a line feed. The function 
   result is true if 'Y' or 'y' was pressed, and false otherwise.

   See also: <Con_JaNee>
*/

int Con_JaNee(const char *prompt);
/* Dutch or German version of YesNo. Prompts with '? (J/N) : ' and
   waits for 'J', 'j', 'N' or 'n'.

   See also: <Con_YesNo>
*/

void Con_WaitCR(void);
/* Displays the text ' CR:' and waits until the Return key is pressed.
   A carriage return and a line feed character is then echoed. */

#define Con_Message(msg)  { nl(); cprintf(msg); nl(); }
/* void Con_Message(const char *msg); */
/* Displays the msg string, prededed and followed by a carriage return 
   and a line feed character. */

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* ifndef Con_Lib */
