/* CONLIB.C : CRT Console constants and routines

  Title   : CONLIB
  Version : 4.1
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Date    : Jan 27,1997
  Author  : J.R. Ferguson
  Usage   : Function library
*/

#include <dos.h>
#include "conlib.h"

static const char _Con_KeyTable[256] = {
  0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8A,
  0xD1,0xD7,0xC5,0xD2,0xD4,0xD9,0xD5,0xC9,
  0xCF,0xD0,0x00,0x00,0x00,0x00,0xC1,0xD3,
  0xC4,0xC6,0xC7,0xC8,0xCA,0xCB,0xCC,0x00,
  0x00,0x00,0x00,0x00,0xDA,0xD8,0xC3,0xD6,
  0xC2,0xCE,0xCD,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xF1,0xF2,0xF3,0xF4,0xF5,
  0xF6,0xF7,0xF8,0xF9,0xFA,0x00,0x00,0x87,
  0x88,0x89,0x00,0x84,0x85,0x86,0x00,0x81,
  0x82,0x83,0x80,0xFF,0xA1,0xA2,0xA3,0xA4,
  0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0x91,0x92,
  0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,
  0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,
  0xE9,0xEA,0x8B,0x8C,0x8E,0x8F,0xAE,0xAF,
  0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,
  0xB9,0xB0,0xAD,0xBD,0x9D,0xFB,0xFC,0xAB,
  0xAC,0x9B,0x9C,0xEB,0xEC,0x9F,0x00,0x8D,
  0x00,0x9E,0x90,0xA0,0x00,0x00,0x00,0xED,
  0xEE,0xEF,0x00,0xDF,0xBE,0xBF,0x00,0xDC,
  0xDD,0xDE,0xDB,0xF0,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

int Con_TstEnhKbd(void)
#ifdef _Windows
{ return 0; }
#else
{ struct REGPACK cpu;

  cpu.r_ax= 0x0500;
  cpu.r_cx= 0xFFFF;
  intr(0x16,&cpu);         /* Stuff FFFFh into keyboard buffer */

  cpu.r_ax= 0x1100;
  intr(0x16,&cpu);         /* Get extended keyboard status */
  if (cpu.r_ax != 0xFFFF)  /* Check if FFFFh was returned */
    return 0;
  else {
    cpu.r_ax= 0x1000;
    intr(0x16,&cpu);       /* If so, remove key from buffer */
    return 1;
  }
}
#endif

char Con_Key(void)
{ char c;

  return ( ((c=getch()) != '\0') ? c : _Con_KeyTable[(unsigned char)getch()]);
}

int Con_YesNo(const char *prompt)
{ char option;

  cprintf("%s? (Y/N) : ",prompt);
  while ( ((option=Con_UppKey()) != 'Y') && (option != 'N') ) ;
  cprintf("%c",option); nl();
  return option == 'Y';
}

int Con_JaNee(const char *prompt)
{ char option;

  cprintf("%s? (J/N) : ",prompt);
  while ( ((option=Con_UppKey()) != 'J') && (option != 'N') ) ;
  cprintf("%c",option); nl();
  return option == 'J';
}

void Con_WaitCR(void)
{
  cprintf(" CR:");
  while (Con_Key() != '\r') ;
  nl();
}
