/* CHRTST.C : Test character functions in ctype.h en chrlib.h

  Title   : CHRTST
  version : 4.0
  date    : Nov 23,1996
  Author  : J R Ferguson
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage   : Test program

[ project file:
chrtst   (chrlib.h)
chrlib   (chrlib.h)
]
*/

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "chrlib.h"

#define MAXNAAM     9
#define ESC        27

#define newline()  printf("\n")
#define waitcr()   printf(" CR:"); while (getch() != '\r')
#define putasc(c)  putch(isprint(c) ? (c) : '.')

void wrcond(char *txt, int i)
{
  char name[MAXNAAM];

  strcpy(name,txt);
  if (i != 0) strupr(name);
  printf(name);
}

void wrorder(int i)
{
  putch( (i==0) ? '0' : ( (i > 0) ? '+' : '-' )  );
}

int main(void)
{
  char   c0,c;

  clrscr();
  printf("\n\nTest CHRLIB\n");
  c0 = ESC;
  do {
    printf("\nPress a key (ESC=stop) : ");
    c= getch();
    putasc(c);
    printf("  decimal : %03u  hexadec: %02X\n",c,c);
    printf  (  "ToAscii: "); putasc(Chr_ToAscii(c));
    printf  ("  ToUpper: "); putasc(Chr_ToUpper(c));
    printf  ("  ToLower: "); putasc(Chr_ToLower(c));
    if (c0 != ESC) {
      printf("  Order: "   ); wrorder(Chr_Order   (c,c0));
      printf("  UppOrder: "); wrorder(Chr_UppOrder(c,c0));
      printf("  LexOrder: "); wrorder(Chr_LexOrder(c,c0));
    }
    newline();
    wrcond("IsAlpha  ",Chr_IsAlpha(c));
    wrcond("IsDigit  ",Chr_IsDigit(c));
    wrcond("IsAlnum  ",Chr_IsAlnum(c));
    wrcond("IsAscii  ",Chr_IsAscii(c));
    wrcond("IsCntrl  ",Chr_IsCntrl(c));
    wrcond("IsPrint  ",Chr_IsPrint(c));
    wrcond("IsGraph  ",Chr_IsGraph(c));
    newline();
    wrcond("IsLower  ",Chr_IsLower(c));
    wrcond("IsUpper  ",Chr_IsUpper(c));
    wrcond("IsPunct  ",Chr_IsPunct(c));
    wrcond("IsSpace  ",Chr_IsSpace(c));
    wrcond("IsBDigit ",Chr_IsBDigit(c));
    wrcond("IsQDigit ",Chr_IsQDigit(c));
    wrcond("IsXDigit ",Chr_IsXDigit(c));
    newline();
    c0 = c;
  } while ( c != ESC );
  waitcr();
  return 0;
}
