/* CHRLIB.H : Character functions

  Title   : CHRLIB
  version : 4.0
  Date    : Nov 18,1996
  Author  : J R Ferguson
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage   : Header file
*/

/*.hlptx skip 1*/
#ifndef Chr_Lib
#define Chr_Lib

#include <ctype.h>

#define Chr_IsAlnum(c)  isalnum(c)
#define Chr_IsAlpha(c)  isalpha(c)
#define Chr_IsAscii(c)  isascii(c)
#define Chr_IsCntrl(c)  iscntrl(c)
#define Chr_IsDigit(c)  isdigit(c)
#define Chr_IsGraph(c)  isgraph(c)
#define Chr_IsLower(c)  islower(c)
#define Chr_IsPrint(c)  isprint(c)
#define Chr_IsPunct(c)  ispunct(c)
#define Chr_IsSpace(c)  isspace(c)
#define Chr_IsUpper(c)  isupper(c)
#define Chr_IsXDigit(c) isxdigit(c)

/*.hlptx skip 4*/
#ifdef __cplusplus
extern "C" {
#endif

#define Chr_IsBDigit(c) (((c) == '0') || ((c) == '1'))
/* test for binary digit */

#define Chr_IsQDigit(c) (((c) >= '0') && ((c) <= '7'))
/* test for octal digit */

#define Chr_ToAscii(c)  toascii(c)
#define Chr_ToLower(c)  tolower(c)
#define Chr_ToUpper(c)  toupper(c)

#define Chr_Order(c1,c2)    ((c1) - (c2))
/* Result <0 if c1<c2, 0 if c1=c2, >0 if c1>c2 */

#define Chr_UppOrder(c1,c2) (toupper(c1) - toupper(c2))
/* like Chr_Order(), ignoring case */

int Chr_LexOrder(char c1, char c2);
/* like Chr_Order(), using lexicographical ordering:
    - high-order bits are ignored,
    - the first group consists of all control characters
    - the second group consists of all punctuation characters
    - the third group consists of all digits ('0'..'9')
    - the last group consists of all letters (ignoring case)
    - within each group the ordering is according to ASCII code.
*/

/*.hlptx skip 4*/
#ifdef __cplusplus
}
#endif
#endif /* ifndef Chr_Lib */
