/* CHRLIB.C : Character functions

  Title   : CHRLIB
  Version : 4.0
  Date    : Nov 18,1996
  Author  : J R Ferguson
  Language: Turbo C 2.0, Turbo C++ 3.1 for Windows
  Usage   : Function library
*/

#include "chrlib.h"

const static char _lex[128] =
/*       0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF */
/*0-3*/ "0000000000000000000000000000000011111111111111112222222222111111"
/*4-7*/ "1444444444444444444444444441111113333333333333333333333333311110";

static int _LexOrd(char c)
{ union  {int n; struct {char lsh,msh;} s;} u;

  u.s.msh = _lex[u.s.lsh= toupper(c & 0x7F)];
  return u.n;
}

int Chr_LexOrder(char c1, char c2)
{
  return _LexOrd(c1) - _LexOrd(c2);
}
