/*
J++Extract
Copyright (C) 2000  Olivier Mengu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#if !defined(_MSC_VER)
#error Microsoft Visual C++ required.
#endif

#define WIN32_LEAN_AND_MEAN
#define STRICT
#include <windows.h>
#include <winbase.h>
#include <windef.h>
#include <wincon.h>
#include <winerror.h>
#include <tchar.h>



#ifdef _DEBUG
#else /* _DEBUG */
#pragma comment(linker, "/ENTRY:main")
#pragma comment(linker, "/NODEFAULTLIB")
#pragma comment(linker, " /LINK50COMPAT")
// E:Execute, R:Read, W:Write, L:Locked, P: S:Shared, D:Discardable
//#pragma comment(linker, "/SECTION:.text,RWEL")
#pragma comment(linker, "/SECTION:.text,RWE")
//#pragma comment(linker, "/SECTION:.idata,RWESDKLPX")
//#pragma comment(linker, "/SECTION:.rdata,RWESDKLPX")
//#pragma comment(linker, "/SECTION:.data,RWESDKLPX")
//#pragma comment(linker, "/MERGE:.idata=.text")
//#pragma comment(linker, "/SECTION:.rdata,RWEL")
//#pragma comment(linker, "/SECTION:.data,RWEL")
#pragma comment(linker, "/MERGE:.rdata=.text")
#pragma comment(linker, "/MERGE:.data=.text")
#endif /* _DEBUG */

#ifndef __cplusplus
#define inline __inline
#endif


#define CHAR_SPACE		_T(' ')
#define CHAR_TAB		_T('\t')
#define CHAR_DQUOTE		_T('\"')
#define CHAR_SLASH		_T('/')


inline static BOOL IsSpace(TCHAR c)
{
	return c == _T(' ') || c == _T('\t');
}

inline static BOOL IsNum(TCHAR c)
{
	return c >= _T('0') && c <= _T('9');
}


LPTSTR NextNonSpace(LPTSTR lpStr)
{
	while (*lpStr && IsSpace(*lpStr)) {
		lpStr++;
#ifdef _MBCS
		if (IsDBCSLeadByte((BYTE)*lpStr))
			lpStr++;
#endif
	}
	return lpStr;
}

LPTSTR NextSpace(LPTSTR lpStr)
{
	while (*lpStr && !IsSpace(*lpStr)) {
		if (*lpStr == CHAR_DQUOTE) {
			while (*(++lpStr) && *lpStr != CHAR_DQUOTE) {
#ifdef _MBCS
				if (IsDBCSLeadByte((BYTE)*lpStr))
					lpStr++;
#endif
			}
			if (*lpStr)
				lpStr++;	// On saute le " de fin
		} else {
			lpStr++;
#ifdef _MBCS
			if (IsDBCSLeadByte((BYTE)*lpStr))
				lpStr++;
#endif
		}
	}
	return lpStr;
}




// Copie d'une chane jusqu'au premier blanc, en enlevant les "
// Retourne la position de ce blanc.
// Les blancs  l'intrieur des " sont ignors.
// nBufferMax : taille maxi du buffer destination en caractres (1 ou 2 octets) (inclus la place pour le '\0' final).
// Adapt aux noms de fichiers qui ne contiennent pas de " (donc pas besoin d'avoir la possibilit de les escaper)
// Retourne le nombre de caractres copis ('\0' exclus)
LPTSTR CopyWithoutDQuotes(LPTSTR lpDest, LPCTSTR lpSrc, LPDWORD pnBufferMax)
{
	DWORD dwStrLen = 0;
	while (dwStrLen < *pnBufferMax && *lpSrc && !IsSpace(*lpSrc)) {
		if (*lpSrc == CHAR_DQUOTE) {
			lpSrc++;
			while (dwStrLen < *pnBufferMax && *lpSrc && *lpSrc != CHAR_DQUOTE) {
				*lpDest++ = *lpSrc++;
				dwStrLen++;
#ifdef _MBCS
				if (IsDBCSLeadByte((BYTE)*lpSrc)) {
					*lpDest++ = *lpSrc++;
					dwStrLen++;
				}
#endif
				if (lpSrc[0] == CHAR_DQUOTE && lpSrc[1] == CHAR_DQUOTE) {
					*lpDest++ = CHAR_DQUOTE;
					lpSrc += 2;
					dwStrLen++;
				}
			}
			if (*lpSrc != CHAR_DQUOTE)
				break;
			lpSrc++;	// On saute le " de fin
		} else {
			*lpDest++ = *lpSrc++;
			dwStrLen++;
#ifdef _MBCS
			if (IsDBCSLeadByte((BYTE)*lpSrc)) {
				*lpDest++ = *lpSrc++;
				dwStrLen++;
			}
#endif
		}
	}
	*lpDest = 0;
	*pnBufferMax = dwStrLen;
	return (LPTSTR)lpSrc;
}


// Get the file name without path and without extension
// dwBufferLength includes the final null char
DWORD GetFileName(LPCTSTR pszFilePath, LPTSTR pszBuffer, DWORD dwBufferLength)
{
	LPTSTR lpLastSlash = (LPTSTR)pszFilePath;
	LPTSTR lpLastDot = NULL;
	LPTSTR lpTmp = (LPTSTR)pszFilePath;
	DWORD dwFileNameLength;

	while (*lpTmp) {
		if (*lpTmp == _T('\\') || *lpTmp == _T('/')) {
			lpLastSlash = lpTmp;
			lpLastDot = NULL;
		} else if (*lpTmp == '.')
			lpLastDot = lpTmp;
		lpTmp++;
	}
	if (!lpLastDot)
		lpLastDot = lpTmp;
	dwFileNameLength = (lpLastDot-lpLastSlash)/sizeof(TCHAR);
	if (dwFileNameLength < dwBufferLength)
		lstrcpyn(pszBuffer, lpLastSlash+1, dwFileNameLength);
	return dwFileNameLength;
}



static HANDLE hStdOut, hStdErr;


inline void PrintString(HANDLE h, LPCTSTR pszMsg)
{
	DWORD dwWritten;
	WriteConsole(h, pszMsg, lstrlen(pszMsg)*sizeof(pszMsg[0]), &dwWritten, NULL);
}

void PrintF(HANDLE h, LPCTSTR pszFormatMsg, ...)
{
	DWORD dwWritten;
	int iChars;
	TCHAR szTmp[1024];
	va_list arglist;

	va_start(arglist, pszFormatMsg);
	iChars = wvsprintf(szTmp, pszFormatMsg, arglist);
	WriteConsole(h, szTmp, iChars*sizeof(szTmp[0]), &dwWritten, NULL);
}


void PrintSystemErrorMessage(LPCTSTR pszMsgFormat)
{
	LPTSTR pszSystemMsg = NULL;
	TCHAR szMsg[1024];
	DWORD dwWritten;
	DWORD dwCount;
	
	dwCount = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM|FORMAT_MESSAGE_ALLOCATE_BUFFER, NULL, GetLastError(), 0, (LPTSTR)&pszSystemMsg, 0, NULL);
	if (GetConsoleOutputCP() == GetOEMCP())
		CharToOem(pszSystemMsg, pszSystemMsg); // not UNICODE safe !!
	if (pszMsgFormat) {
		// Risque de Buffer Overflow !
		wsprintf(szMsg, pszMsgFormat, pszSystemMsg);
		WriteConsole(hStdErr, szMsg, lstrlen(szMsg)*sizeof(szMsg[0]), &dwWritten, NULL);
	} else
		WriteConsole(hStdErr, pszSystemMsg, dwCount*sizeof(pszSystemMsg[0]), &dwWritten, NULL);
	LocalFree(pszSystemMsg);
}

static void PrintFileError(LPCTSTR pszFileName)
{
	PrintString(hStdErr, pszFileName);
	PrintSystemErrorMessage(_TEXT(": %s"));
}


static void PrintExtractFileError(LPCSTR pszFileName)
{
	PrintString(hStdErr, pszFileName);
	PrintSystemErrorMessage(_TEXT(": %hs"));
}


void PrintHelp()
{
	TCHAR szHelpMsg[] = _TEXT(
		"J++Extract 1.0, Copyright (C) 2000 Olivier Mengu.\r\n"
		"J++Extract comes with ABSOLUTELY NO WARRANTY; see License.txt\r\n"
		"This is free software, and you are welcome to redistribute it\r\n"
		"under certain conditions.\r\n"
		"\r\n"
		"- Extracts in the current directory the files inside a .exe generated by\r\n"
		"Microsoft Visual J++.\r\n"
		"- Creates a executable-file.bat to launch the application from those files.\r\n"
		"- Extracts the icon to executable-file-1.ico.\r\n"
		"- Creates a executable-file.j++ that contain the structure of the .exe.\r\n"
		"\r\n"
		"Usage:   J++EXTRACT executable-file.exe\r\n");
	DWORD dwWritten;

	CharToOem(szHelpMsg, szHelpMsg);
	WriteConsole(hStdOut, szHelpMsg, sizeof(szHelpMsg)-1, &dwWritten, NULL);
	ExitProcess(255);
}



LPBYTE GetResourcePtrW(HANDLE hModule, LPCWSTR lpwResourceId, LPCWSTR lpwType, LPDWORD lpdwSizeResource)
{
	HRSRC hRsrc;
	HGLOBAL hMemRsrc;

	hRsrc = FindResourceW(hModule, lpwResourceId, lpwType);
	if (!hRsrc)
		return NULL;
	if (lpdwSizeResource) {
		*lpdwSizeResource = SizeofResource(hModule, hRsrc);
		if (!*lpdwSizeResource)
			return NULL;
	}
	hMemRsrc = LoadResource(hModule, hRsrc);
	if (!hMemRsrc)
		return NULL;
	return (LPBYTE)LockResource(hMemRsrc);
}


// Creates a new file, creating the directories
HANDLE CreateFileWithPathA(LPCSTR pszFileName)
{
	CHAR szPath[MAX_PATH];
	LPSTR pSrc, pCurrent;

	// Signature of .class file (4 first bytes) : CA FE BA BE
	pCurrent = szPath;
	pSrc = (LPSTR)pszFileName;
	do {
		while (*pSrc && *pSrc != '/')
			*pCurrent++ = *pSrc++;
		*pCurrent = '\0';
		if (!*pSrc)
			break;
		if (!CreateDirectoryA(szPath, NULL)) {
			if (GetLastError() != ERROR_ALREADY_EXISTS)
				return INVALID_HANDLE_VALUE;
		}
		*pCurrent++ = '\\';
		pSrc++;
	} while (1);
	return CreateFileA(szPath, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, 0, NULL);
}



BOOL ExtractFile(LPCSTR pszFileName, LPVOID pData, DWORD dwSize)
{
	HANDLE hOutput;
	DWORD dwWritten;

	// Signature d'un fichier .class (4 premiers octets) : CA FE BA BE
	hOutput = CreateFileWithPathA(pszFileName);
	if (hOutput == INVALID_HANDLE_VALUE) {
		PrintExtractFileError(pszFileName);
		return FALSE;
	}
	if (!WriteFile(hOutput, pData, dwSize, &dwWritten, NULL) || dwWritten != dwSize)
		PrintExtractFileError(pszFileName);
	CloseHandle(hOutput);
	return dwWritten == dwSize;
}

BOOL ExtractResource(HANDLE hModule, LPCWSTR pwszResourceId, LPCSTR pszFileName)
{
	HANDLE hOutput;
	DWORD dwWritten;
	LPBYTE pMemRsrc;
	DWORD dwSizeRsrc;

	pMemRsrc = GetResourcePtrW(hModule, pwszResourceId, (LPCWSTR)RT_RCDATA, &dwSizeRsrc);
	if (!pMemRsrc) {
		PrintExtractFileError(pszFileName);
		return FALSE;
	}

	hOutput = CreateFileWithPathA(pszFileName);
	if (hOutput == INVALID_HANDLE_VALUE) {
		PrintExtractFileError(pszFileName);
		return FALSE;
	}
	if (!WriteFile(hOutput, pMemRsrc, dwSizeRsrc, &dwWritten, NULL) || dwWritten != dwSizeRsrc)
		PrintExtractFileError(pszFileName);
	CloseHandle(hOutput);
	return dwWritten == dwSizeRsrc;
}




// See http://msdn.microsoft.com/library/techart/msdn_icons.htm
#pragma pack( push )
#pragma pack( 2 )
typedef struct
{
    BYTE        bWidth;          // Width, in pixels, of the image
    BYTE        bHeight;         // Height, in pixels, of the image
    BYTE        bColorCount;     // Number of colors in image (0 if >=8bpp)
    BYTE        bReserved;       // Reserved ( must be 0)
    WORD        wPlanes;         // Color Planes
    WORD        wBitCount;       // Bits per pixel
    DWORD       dwBytesInRes;    // How many bytes in this resource?
	DWORD       dwImageOffset;   // Where in the file is this image?
} ICONDIRENTRY, *LPICONDIRENTRY;
#pragma pack( pop )

#pragma pack( push )
#pragma pack( 2 )
typedef struct
{
    WORD           idReserved;   // Reserved (must be 0)
    WORD           idType;       // Resource Type (1 for icons)
    WORD           idCount;      // How many images?
    ICONDIRENTRY   idEntries[1]; // An entry for each image (idCount of 'em)
} ICONDIR, *LPICONDIR;
#pragma pack( pop )

typedef struct
{
   BITMAPINFOHEADER   icHeader;      // DIB header
   RGBQUAD         icColors[1];   // Color table
   BYTE            icXOR[1];      // DIB bits for XOR mask
   BYTE            icAND[1];      // DIB bits for AND mask
} ICONIMAGE, *LPICONIMAGE;




#pragma pack( push )
#pragma pack( 2 )
typedef struct
{
	BYTE   bWidth;               // Width, in pixels, of the image
	BYTE   bHeight;              // Height, in pixels, of the image
	BYTE   bColorCount;          // Number of colors in image (0 if >=8bpp)
	BYTE   bReserved;            // Reserved
	WORD   wPlanes;              // Color Planes
	WORD   wBitCount;            // Bits per pixel
	DWORD  dwBytesInRes;		 // how many bytes in this resource?
	WORD   nID;                  // the ID
} GRPICONDIRENTRY, *LPGRPICONDIRENTRY;
#pragma pack( pop )

#pragma pack( push )
#pragma pack( 2 )
typedef struct 
{
   WORD            idReserved;   // Reserved (must be 0)
   WORD            idType;       // Resource type (1 for icons)
   WORD            idCount;      // How many images?
   GRPICONDIRENTRY   idEntries[1]; // The entries for each image
} GRPICONDIR, *LPGRPICONDIR;
#pragma pack( pop )



// Extracts the Icon resource to a .ico file
BOOL ExtractIconResourceToFile(HMODULE hModule, WORD idResource, LPCTSTR szFileName)
{
	LPGRPICONDIR pGrpIconDir;
	LPICONIMAGE *ppIconImages;
	LPICONDIR pIconDir;
	HANDLE hIconFile;
	WORD nImages;
	DWORD dwImageOffset, dwIconDirSize;
	int i;
	DWORD dwWritten;

	// Read resource icon group
	pGrpIconDir = (LPGRPICONDIR)GetResourcePtrW(hModule, (LPCWSTR)MAKEINTRESOURCE(idResource), (LPCWSTR)RT_GROUP_ICON, NULL);
	if (!pGrpIconDir)
		return FALSE;
	nImages = pGrpIconDir->idCount;
	dwImageOffset = dwIconDirSize = sizeof(ICONDIR)+(nImages-1)*sizeof(ICONDIRENTRY);
	pIconDir = (LPICONDIR)LocalAlloc(LPTR, dwImageOffset);
	pIconDir->idReserved = 0;
	pIconDir->idType = 1; // Icon
	pIconDir->idCount = nImages;
	ppIconImages = (LPICONIMAGE*)LocalAlloc(LPTR|LMEM_ZEROINIT, nImages*sizeof(LPICONIMAGE));
	for(i=0; i<nImages; i++) {
		// Fills pIconDir.
		// Note that we use the fact GRPICONDIR and ICONDIR have nearly the same structure
		CopyMemory(&pIconDir->idEntries[i], &pGrpIconDir->idEntries[i], min(sizeof(*pGrpIconDir), sizeof(*pIconDir)));
		pIconDir->idEntries[0].dwImageOffset = dwImageOffset;
		dwImageOffset += pGrpIconDir->idEntries[i].dwBytesInRes;
		ppIconImages[i] = (LPICONIMAGE)GetResourcePtrW(hModule, (LPCWSTR)MAKEINTRESOURCE(pGrpIconDir->idEntries[i].nID), (LPCWSTR)RT_ICON, NULL);
		if (!ppIconImages[i]) {
			LocalFree(pIconDir);
			LocalFree(ppIconImages);
			return FALSE;
		}
	}
	// Writting data to the file
	hIconFile = CreateFile(szFileName, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hIconFile == INVALID_HANDLE_VALUE) {
		LocalFree(pIconDir);
		LocalFree(ppIconImages);
		return FALSE;
	}
	WriteFile(hIconFile, pIconDir, dwIconDirSize, &dwWritten, NULL);
	if (dwIconDirSize != dwWritten) {
		CloseHandle(hIconFile);
		LocalFree(pIconDir);
		LocalFree(ppIconImages);
		return FALSE;
	}
	for(i=0; i<nImages; i++) {
		WriteFile(hIconFile, ppIconImages[i], pIconDir->idEntries[0].dwBytesInRes, &dwWritten, NULL);
		if (pIconDir->idEntries[0].dwBytesInRes != dwWritten) {
			CloseHandle(hIconFile);
			LocalFree(pIconDir);
			LocalFree(ppIconImages);
			return FALSE;
		}
	}
	LocalFree(pIconDir);
	LocalFree(ppIconImages);
	CloseHandle(hIconFile);
	return TRUE;
}





#ifdef FILEDESC
#error FILEDESC already defined !!
#endif
typedef struct {
	DWORD dwFileNameOffset;
	DWORD dwFileSize;
	DWORD dwFileDataOffset;
	DWORD dwResIdOffset;
	DWORD dwFileFlags;
} FILEDESC;


void main()
{
	TCHAR szInputFile[MAX_PATH];
	TCHAR szProjectName[MAX_PATH];
	HANDLE hModule;
	LPBYTE pMemRsrc, pMemRsrc1001;
	DWORD dwSizeRsrc, dwSizeRsrc1001;
	DWORD dwWritten;
	DWORD nBufferSize;
	LPTSTR lpCmdLine;
	LPTSTR lpTmp;
	TCHAR szTmp[2048];
	DWORD dwTmp;
	DWORD n;
	FILEDESC *pFileDesc;
	unsigned int i;
	HANDLE hMapFile;
	const CHAR cszMapHeader[] = \
		"[Header]\r\n"
		"Version=1.0\r\n"
		"Generator=\"J++Extract 1.0\"\r\n"
		"\r\n"
		"[Icons]\r\n"
		"\r\n"
		"[Class Files]\r\n"
		"\r\n"
		"[Resources]\r\n";
	CHAR szMapFile[MAX_PATH];
#ifdef UNICODE
	WCHAR tszMapFile[MAX_PATH];
#else
#define tszMapFile szMapFile
#endif
#ifdef _DEBUG
	DWORD dwLast;
#endif

	hStdOut = GetStdHandle(STD_OUTPUT_HANDLE);
	hStdErr = GetStdHandle(STD_ERROR_HANDLE);

	// ###########################
	// Parsing of the command line
	// ###########################
	lpCmdLine = GetCommandLine();
	lpTmp = NextNonSpace(NextSpace(lpCmdLine));
	// aucun paramtre  => aide
	// -h ou -?  => aide
	if (lpTmp[0] == '\0' || (lpTmp[0] == _T('-') && (lpTmp[1] == _T('?') || lpTmp[1] == _T('h'))))
		PrintHelp();

	nBufferSize = sizeof(szInputFile)/sizeof(szInputFile[0]);
	lpTmp = CopyWithoutDQuotes(szInputFile, lpTmp, &nBufferSize);

	GetFileName(szInputFile, szProjectName, sizeof(szProjectName)/sizeof(szProjectName[0]));
	//PrintF(hStdOut, "Project: %s\r\n", szProjectName);
	

	// #####################
	// Loading of the target
	// #####################
	hModule = LoadLibraryEx(szInputFile, NULL, LOAD_LIBRARY_AS_DATAFILE);
	//LoadLibrary
	if (!hModule) {
		PrintFileError(szInputFile);
		ExitProcess(1);
	}

	// #########################
	// Loading the main resource
	// #########################
	pMemRsrc = GetResourcePtrW(hModule, (LPCWSTR)MAKEINTRESOURCE(1000), (LPCWSTR)RT_RCDATA, &dwSizeRsrc);
	if (!pMemRsrc) {
		PrintFileError(szInputFile);
		ExitProcess(3);
	}

	if (pMemRsrc[0]!='D' || pMemRsrc[1]!='N' || pMemRsrc[2]!='R' || pMemRsrc[3]!='C') {
		PrintF(hStdErr, "This isn't an executable file generated by Microsoft J++.\r\n");
		ExitProcess(2);
	}

	// ###################################################
	// Loading the resource that contains the class to run
	// ###################################################
	pMemRsrc1001 = GetResourcePtrW(hModule, (LPCWSTR)MAKEINTRESOURCE(1001), (LPCWSTR)RT_RCDATA, &dwSizeRsrc1001);
	if (!pMemRsrc1001) {
		PrintFileError(szInputFile);
		ExitProcess(2);
	}


	// #############################
	// Creation of the .bat launcher
	// #############################
	if (dwSizeRsrc1001 < MAX_PATH && ((LPWSTR)(pMemRsrc1001+dwSizeRsrc1001-2))[0] == _T('\0')) {
		HANDLE hLauncherFile;
		lstrcpy(szTmp, szProjectName);
		lstrcat(szTmp, _TEXT(".bat"));
		hLauncherFile = CreateFile(szTmp, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hLauncherFile == INVALID_HANDLE_VALUE)
			PrintFileError(szTmp);
		else {
			dwTmp = wsprintf(szTmp, _TEXT("@rem %s launcher created by J++Xtract 1.0\r\n@jview %ls"), szProjectName, pMemRsrc1001);
			WriteFile(hLauncherFile, szTmp, dwTmp, &dwWritten, NULL);
			CloseHandle(hLauncherFile);
		}
	} else {
		PrintF(hStdErr, "Invalid resource 1001\r\n");
	}


	// ##############################
	// Initialization of the map file
	// ##############################
	tszMapFile[0] = '.';	// We need to add a path (.). By default WritePrivateProfileString
	tszMapFile[1] = '\\';	// creates files in the Windows directory.
	lstrcpy(&tszMapFile[2], szProjectName);
	lstrcat(&tszMapFile[2], _TEXT(".j++"));
#ifdef UNICODE
	WideCharToMultiByte(CP_ACP, 0, tszMapFile, -1, szMapFile, sizeof(szMapFile), NULL, NULL);
#endif
	hMapFile = CreateFile(tszMapFile, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hMapFile == INVALID_HANDLE_VALUE) {
		PrintFileError(_TEXT(tszMapFile));
	}

	WriteFile(hMapFile, cszMapHeader, sizeof(cszMapHeader)-sizeof(cszMapHeader[0]), &dwWritten, NULL);

	CloseHandle(hMapFile);


	// #########################
	// Extraction of the icon #1
	// #########################
	lstrcpy(szTmp, szProjectName);
	lstrcat(szTmp, _TEXT("-1.ico"));
	if (!ExtractIconResourceToFile(hModule, 1, szTmp)) {
		PrintSystemErrorMessage("Extraction of icon #1: %s\r\n");
	} else {
		PrintF(hStdOut, "Icon #1 -> %s\r\n", szTmp);
		WritePrivateProfileString(_TEXT("Icons"), "#1", szTmp, tszMapFile);
	}

// Shortcut

#ifdef _DEBUG
	dwLast = 0;
#endif

	// ###################
	// Extraction of files
	// ###################
	n = ((LPDWORD)pMemRsrc)[1];
	pFileDesc = (FILEDESC*)(((LPBYTE)pMemRsrc)+0x10);
	for(i=0; i<n; i++) {
//		PrintString(hStdOut, (LPSTR)pMemRsrc+pFileDesc[i].dwFileNameOffset);
//		PrintF(hStdOut, _TEXT(": 0x%0X\r\n"), pFileDesc[i].dwFileFlags);

#ifdef _DEBUG
		if (pFileDesc[i].dwFileNameOffset > dwLast)
			dwLast = pFileDesc[i].dwFileNameOffset+lstrlenA((LPSTR)pMemRsrc+pFileDesc[i].dwFileNameOffset)+1;
#endif

		if (pFileDesc[i].dwFileFlags == 0xFFFFFFFF) { // Class file
			PrintF(hStdOut, _TEXT("%hs -> file\r\n"), (LPSTR)pMemRsrc+pFileDesc[i].dwFileNameOffset);
			ExtractFile((LPSTR)pMemRsrc+pFileDesc[i].dwFileNameOffset, (LPSTR)pMemRsrc+pFileDesc[i].dwFileDataOffset, pFileDesc[i].dwFileSize);
			WritePrivateProfileStringA("Class Files", (LPSTR)pMemRsrc+pFileDesc[i].dwFileNameOffset, (LPSTR)pMemRsrc+pFileDesc[i].dwFileNameOffset, szMapFile);
#ifdef _DEBUG
			if (pFileDesc[i].dwFileDataOffset+pFileDesc[i].dwFileSize > dwLast)
				dwLast = pFileDesc[i].dwFileDataOffset+pFileDesc[i].dwFileSize;
#endif
		} else if (pFileDesc[i].dwFileFlags == 0x8000000A) { // Resource file
			PrintF(hStdOut, _TEXT("%hs -> resource \"%ls\"\r\n"), (LPSTR)pMemRsrc+pFileDesc[i].dwFileNameOffset, (LPWSTR)((LPSTR)pMemRsrc+pFileDesc[i].dwResIdOffset));
			ExtractResource(hModule, (LPWSTR)((LPSTR)pMemRsrc+pFileDesc[i].dwResIdOffset), (LPSTR)pMemRsrc+pFileDesc[i].dwFileNameOffset);
			WideCharToMultiByte(CP_UTF8, 0, (LPWSTR)((LPSTR)pMemRsrc+pFileDesc[i].dwResIdOffset), -1, szTmp, sizeof(szTmp), NULL, NULL);
			WritePrivateProfileStringA("Resources", (LPSTR)szTmp, (LPSTR)pMemRsrc+pFileDesc[i].dwFileNameOffset, szMapFile);
#ifdef _DEBUG
			if (pFileDesc[i].dwResIdOffset > dwLast)
				dwLast = pFileDesc[i].dwResIdOffset+lstrlenW((LPWSTR)((LPSTR)pMemRsrc+pFileDesc[i].dwResIdOffset))+2;
#endif
		} else
			PrintF(hStdErr, _TEXT("%hs -> ??? (unknown flags 0x%0X)\r\n"), (LPSTR)pMemRsrc+pFileDesc[i].dwFileNameOffset, pFileDesc[i].dwFileFlags);
	}

#ifdef _DEBUG
	PrintF(hStdOut, _TEXT("Pos: 0x%0X\r\n"), dwLast);
	PrintF(hStdOut, _TEXT("Size: 0x%0X\r\n"), dwSizeRsrc);
	PrintF(hStdOut, _TEXT("[0x000000] 0x%08X, %d, \"%hc%hc%hc%hc\"\r\n"), ((LPDWORD)pMemRsrc)[0], ((LPDWORD)pMemRsrc)[0], ((LPBYTE)pMemRsrc)[0], ((LPBYTE)pMemRsrc)[1], ((LPBYTE)pMemRsrc)[2], ((LPBYTE)pMemRsrc)[3]);
	PrintF(hStdOut, _TEXT("[0x000004] 0x%08X, %d\r\n"), ((LPDWORD)pMemRsrc)[1], ((LPDWORD)pMemRsrc)[1]);
	PrintF(hStdOut, _TEXT("[0x000008] 0x%08X, %d\r\n"), ((LPDWORD)pMemRsrc)[2], ((LPDWORD)pMemRsrc)[2]);
	PrintF(hStdOut, _TEXT("[0x00000C] 0x%08X, %d\r\n"), ((LPDWORD)pMemRsrc)[3], ((LPDWORD)pMemRsrc)[3]);
#endif	

	FreeLibrary(hModule);
}
