/*
** Test program for joystick library.
**
** This file is part of:
**
** Joystick Library for Dos.
** Version: 1.2
**
** Last modified: September 23rd, 1997
**
** (C) 1997 Simone Zanella Productions.
**
** E-mail: simone@zanella-hifi.com
**         zanella@prometeo.it
**         szanella@dsi.unive.it
**
** Web:    http://www.dsi.unive.it/~szanella/index.htm
**         http://members.tripod.com/~szanella/index.htm
**
** Changes from version 1.1:
** - added support for 8-button joysticks.
**
** Changes from version 1.0:
**
** - added support for 4 and 6 buttons joysticks;
** - added command line parameter mode;
** - changed calibration to manual, to avoid incompatibilities and
**   to get a faster reading;
** - calibration is now saved to JTEST.JC, in JTEST.EXE directory;
** - removed tolerances.
**
** --------------------------------------------------------
**
** This is freeware: use it as you like, but ALWAYS include
** the original author's name in the docs of your program.
**
** --------------------------------------------------------
*/

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "joystick.h"

#ifndef __BORLANDC__
#define min(a, b)    (((a) < (b)) ? (a) : (b))
#define max(a, b)    (((a) > (b)) ? (a) : (b))
#endif

static int mode = JOY_2BUTTONS;

void printstatus(unsigned char jready, unsigned int j0, unsigned int j1)
{
  /* Show status for both joysticks */

  char l[13][26];
  unsigned char j, o, ln;
  unsigned int jflags;

  strcpy(l[0],  "                     ");
  strcpy(l[1],  "   -      -");
  strcpy(l[2],  "                     ");
  strcpy(l[3],  "         -");
  strcpy(l[4],  "                     ");
  strcpy(l[5],  "");
  strcpy(l[6],  "   A           A     ");
  strcpy(l[7],  "");
  strcpy(l[8],  "   B           B     ");
  strcpy(l[9],  "");
  strcpy(l[10], "   C           C     ");
  strcpy(l[11], "");
  strcpy(l[12], "   D           D     ");

  for (j = 0; j < 2; j++)
    if (jready & (j + 1))
    {
      jflags = j ? j1 : j0;
      if (jflags & JOY_UP)
      {
        ln = 0;
        if (jflags & JOY_LT || jflags & JOY_RT)
          o = (jflags & JOY_LT) ? 3 : 9;
        else
          o = 6;
      }
      else
        if (jflags & JOY_DN)
        {
          ln = 4;
          if (jflags & JOY_LT || jflags & JOY_RT)
            o = (jflags & JOY_LT) ? 3 : 9;
          else
            o = 6;
        }
        else
        {
          ln = 2;
          if (jflags & JOY_LT || jflags & JOY_RT)
            o = (jflags & JOY_LT) ? 3 : 9;
          else
            o = 6;
        }
      l[ln][o + (j ? 14 : 0)] = 0xDB;
      l[ln][o + (j ? 15 : 1)] = 0xDB;

      if (jflags & JOY_AF)
      {
        l[6][(j ? 20 : 6)] = 0xDB;
        l[6][(j ? 21 : 7)] = 0xDB;
      }

      if (jflags & JOY_BF)
      {
        l[8][(j ? 20 : 6)] = 0xDB;
        l[8][(j ? 21 : 7)] = 0xDB;
      }

      if (mode > JOY_2BUTTONS)
      {
        if (jflags & JOY_CF)
        {
          l[10][(j ? 20 : 6)] = 0xDB;
          l[10][(j ? 21 : 7)] = 0xDB;
        }

        if (jflags & JOY_DF)
        {
          l[12][(j ? 20 : 6)] = 0xDB;
          l[12][(j ? 21 : 7)] = 0xDB;
        }

        if (mode >= JOY_6BUTTONS)
        {
          int i, start;
          char butname = 'E';

          if (mode == JOY_6BUTTONS)
            start = 10;
          else
            start = 6;

          for (i = 0; i < start - 1; i++)
            strcpy(l[i] + 17, "        ");

          l[start][17] = butname++;
          l[start + 2][17] = butname++;

          if (jflags & JOY_EF)
          {
            l[start][20] = 0xDB;
            l[start][21] = 0xDB;
          }

          if (jflags & JOY_FF)
          {
            l[start + 2][20] = 0xDB;
            l[start + 2][21] = 0xDB;
          }

          if (mode == JOY_8BUTTONS)
          {
            l[10][17] = butname++;
            l[12][17] = butname++;

            if (jflags & JOY_GF)
            {
              l[10][20] = 0xDB;
              l[10][21] = 0xDB;
            }

            if (jflags & JOY_HF)
            {
              l[12][20] = 0xDB;
              l[12][21] = 0xDB;
            }
          }

          goto end;
        }
      }
    }
end:
  for (j = 0; j < ((mode == JOY_2BUTTONS) ? 9 : 13); j++)
  {
    cputs(l[j]);
    cputs("\r\n");
  }
}

int main(int argc, char *argv[])
{
  int j, i;
  unsigned int status[2], oldstat[2];
  unsigned char sr;
  char * cp;

  clrscr();
  cprintf("JTEST - Joystick Test v1.2 / (C) 1997 Simone Zanella Productions\r\n\r\n");
  cprintf("Usage: JTEST [mode]\r\n");
  cprintf("Mode can be:  [0] = 2 buttons   1 = 4 buttons   2 = 6 buttons   3 = 8 buttons\r\n\r\n");

  /* Read mode (if specified) */
  if (argc > 1)
    mode = min(max(atoi(argv[1]), JOY_2BUTTONS), JOY_8BUTTONS);

  /* Build configuration file name (it will be located in JTEST.EXE directory) */
  cp = argv[0] + strlen(argv[0]) - 1;
  while (*cp != '.')
    cp--;
  strcpy(cp + 1, "JC");

  /* Initialize joystick(s) */
  sr = wherey();
  j = InstallJoystick(mode, JOY_NONE, argv[0]);
  gotoxy(1, sr);
  for (i = 0; i < 15; i++)
    delline();

  if (j)
  {
    cprintf("Joystick(s): %d. Mode: %d buttons\r\n",
           (j > 2) ? ((mode == JOY_6BUTTONS || mode == JOY_8BUTTONS) ? 1 : 2) : 1, (mode + 1) * 2);

    cprintf("\r\nPress any key on the keyboard to exit..\r\n\r\n");
    oldstat[0] = oldstat[1] = -1;
    sr = wherey();

    /* Wait for a keypress */
    while (!kbhit())
    {
      /* Read joystick(s) */
      ReadJoystick(&(status[0]), &(status[1]));
      if (status[0] != oldstat[0] || status[1] != oldstat[1])
      {
        oldstat[0] = status[0];
        oldstat[1] = status[1];
        gotoxy(1, sr);
        /* Print status */
        printstatus(j, status[0], status[1]);
      }
    }

    /* Remove keypress from keyboard buffer */
    getch();
  }
  else
    cprintf("\r\nNo joysticks found.\r\n");
  return 0;
}
