/*
** Header file for joystick library.
**
** This file is part of:
**
** Joystick Library for Dos.
** Version: 1.2
**
** Last modified: September 23rd, 1997
**
** (C) 1997 Simone Zanella Productions.
**
** E-mail: simone@zanella-hifi.com
**         zanella@prometeo.it
**         szanella@dsi.unive.it
**
** Web:    http://www.dsi.unive.it/~szanella/index.htm
**         http://members.tripod.com/~szanella/index.htm
**
** --------------------------------------------------------
**
** This is freeware: use it as you like, but ALWAYS include
** the original author's name in the docs of your program.
**
** --------------------------------------------------------
*/

/* Bit maps for ReadJoystick */

#define JOY_UP    0x01
#define JOY_DN    0x02
#define JOY_LT    0x04
#define JOY_RT    0x08
#define JOY_AF    0x10
#define JOY_BF    0x20
#define JOY_CF    0x40
#define JOY_DF    0x80
#define JOY_EF    0x100
#define JOY_FF    0x200
#define JOY_GF    0x400
#define JOY_HF    0x800

/* Flags for mode (function InstallJoystick) */

#define JOY_2BUTTONS   0
#define JOY_4BUTTONS   1
#define JOY_6BUTTONS   2
#define JOY_8BUTTONS   3

/* Maps for values returned by InstallJoystick, flags for skipjoy parameter */

#define JOY_NONE       0
#define JOY_FIRST      1
#define JOY_SECOND     2
#define JOY_BOTH       3

/* Public functions to read joystick(s) */

extern unsigned char InstallJoystick(const unsigned char mode, const unsigned char skipjoy, const char * calibfile);
extern void ReadJoystick(unsigned int *first, unsigned int *second);
